/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.asn1.parse;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.Tag;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1Container;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1Header;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1Item;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1ParseResult;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1Reader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Asn1Parser {
    public static void parse(Asn1Container container) throws IOException {
        Asn1ParseResult asn1Obj;
        Asn1Reader reader = new Asn1Reader(container.getBuffer());
        int pos = container.getBodyStart();
        do {
            reader.setPosition(pos);
            asn1Obj = Asn1Parser.parse(reader);
            if (asn1Obj == null) break;
            container.addItem(asn1Obj);
        } while (!asn1Obj.isEOC() && !container.checkBodyFinished(pos += asn1Obj.getEncodingLength()));
        container.setBodyEnd(pos);
    }

    public static Asn1ParseResult parse(ByteBuffer content) throws IOException {
        Asn1Reader reader = new Asn1Reader(content);
        return Asn1Parser.parse(reader);
    }

    public static Asn1ParseResult parse(Asn1Reader reader) throws IOException {
        Asn1ParseResult parseResult;
        if (!reader.available()) {
            return null;
        }
        Asn1Header header = reader.readHeader();
        Tag tmpTag = header.getTag();
        int bodyStart = reader.getPosition();
        if (tmpTag.isPrimitive()) {
            parseResult = new Asn1Item(header, bodyStart, reader.getBuffer());
        } else {
            Asn1Container container = new Asn1Container(header, bodyStart, reader.getBuffer());
            if (header.getLength() != 0) {
                Asn1Parser.parse(container);
            }
            parseResult = container;
        }
        return parseResult;
    }
}

