/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectReader;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectWriter;
import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;

public class NodePlan {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private List<Step> volumeSetPlans = new LinkedList<Step>();
    private String nodeName;
    private String nodeUUID;
    private int port;
    private long timeStamp;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectReader READER = MAPPER.readerFor(NodePlan.class);
    private static final ObjectWriter WRITER = MAPPER.writerFor(MAPPER.constructType((Type)((Object)NodePlan.class)));

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public NodePlan() {
    }

    public NodePlan(String datanodeName, int rpcPort) {
        this.nodeName = datanodeName;
        this.port = rpcPort;
    }

    public List<Step> getVolumeSetPlans() {
        return this.volumeSetPlans;
    }

    void addStep(Step nextStep) {
        Preconditions.checkNotNull(nextStep);
        this.volumeSetPlans.add(nextStep);
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setVolumeSetPlans(List<Step> volumeSetPlans) {
        this.volumeSetPlans = volumeSetPlans;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setURI(String dataNodeName) {
        this.nodeName = dataNodeName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static NodePlan parseJson(String json) throws IOException {
        return (NodePlan)READER.readValue(json);
    }

    public String toJson() throws IOException {
        return WRITER.writeValueAsString(this);
    }

    public String getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }
}

