/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceCancelledException;
import org.apache.hadoop.hdfs.util.Canceler;

@InterfaceAudience.Private
public class SaveNamespaceContext {
    private final FSNamesystem sourceNamesystem;
    private final long txid;
    private final List<Storage.StorageDirectory> errorSDs = Collections.synchronizedList(new ArrayList());
    private final Canceler canceller;
    private final CountDownLatch completionLatch = new CountDownLatch(1);

    SaveNamespaceContext(FSNamesystem sourceNamesystem, long txid, Canceler canceller) {
        this.sourceNamesystem = sourceNamesystem;
        this.txid = txid;
        this.canceller = canceller;
    }

    FSNamesystem getSourceNamesystem() {
        return this.sourceNamesystem;
    }

    long getTxId() {
        return this.txid;
    }

    void reportErrorOnStorageDirectory(Storage.StorageDirectory sd) {
        this.errorSDs.add(sd);
    }

    List<Storage.StorageDirectory> getErrorSDs() {
        return this.errorSDs;
    }

    void markComplete() {
        Preconditions.checkState(this.completionLatch.getCount() == 1L, "Context already completed!");
        this.completionLatch.countDown();
    }

    public void checkCancelled() throws SaveNamespaceCancelledException {
        if (this.canceller.isCancelled()) {
            throw new SaveNamespaceCancelledException(this.canceller.getCancellationReason());
        }
    }
}

