/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TimestampColumnReader
extends PrimitiveColumnReader {
    private final DateTimeZone timeZone;

    public TimestampColumnReader(PrimitiveField field, DateTimeZone timeZone) {
        super(field);
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (type instanceof TimestampWithTimeZoneType) {
            DecodedTimestamp decodedTimestamp = ParquetTimestampUtils.decodeInt96Timestamp(this.valuesReader.readBytes());
            long utcMillis = decodedTimestamp.getEpochSeconds() * 1000L + (long)(decodedTimestamp.getNanosOfSecond() / 1000000);
            type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        } else {
            TrinoTimestampEncoder trinoTimestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)this.timeZone);
            trinoTimestampEncoder.write(ParquetTimestampUtils.decodeInt96Timestamp(this.valuesReader.readBytes()), blockBuilder);
        }
    }
}

