/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampTzMicrosValueWriter
extends PrimitiveValueWriter {
    public TimestampTzMicrosValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long micros = TimestampTzMicrosValueWriter.toMicros((LongTimestampWithTimeZone)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.getObject(block, i));
            this.getValueWriter().writeLong(micros);
            this.getStatistics().updateStats(micros);
        }
    }

    private static long toMicros(LongTimestampWithTimeZone timestamp) {
        return timestamp.getEpochMillis() * 1000L + (long)Timestamps.roundDiv((int)timestamp.getPicosOfMilli(), (long)1000000L);
    }
}

