/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.PrincipalSpecification;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class SetAuthorizationStatement
extends Statement {
    private final QualifiedName source;
    private final PrincipalSpecification principal;

    public SetAuthorizationStatement(QualifiedName source, PrincipalSpecification principal) {
        super(Optional.empty());
        this.source = Objects.requireNonNull(source, "source is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
    }

    public SetAuthorizationStatement(NodeLocation location, QualifiedName source, PrincipalSpecification principal) {
        super(Optional.of(location));
        this.source = Objects.requireNonNull(source, "source is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public PrincipalSpecification getPrincipal() {
        return this.principal;
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.principal);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetAuthorizationStatement o = (SetAuthorizationStatement)obj;
        return Objects.equals(this.source, o.source) && Objects.equals(this.principal, o.principal);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("principal", this.principal).toString();
    }
}

