/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.BooleanReadFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.DoubleReadFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ReadFunction;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class JdbcRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(JdbcRecordCursor.class);
    private final ExecutorService executor;
    private final JdbcColumnHandle[] columnHandles;
    private final ReadFunction[] readFunctions;
    private final BooleanReadFunction[] booleanReadFunctions;
    private final DoubleReadFunction[] doubleReadFunctions;
    private final LongReadFunction[] longReadFunctions;
    private final SliceReadFunction[] sliceReadFunctions;
    private final ObjectReadFunction[] objectReadFunctions;
    private final JdbcClient jdbcClient;
    private final Connection connection;
    private final PreparedStatement statement;
    private final AtomicLong readTimeNanos = new AtomicLong(0L);
    @Nullable
    private ResultSet resultSet;
    private boolean closed;

    public JdbcRecordCursor(JdbcClient jdbcClient, ExecutorService executor, ConnectorSession session, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columnHandles) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.columnHandles = columnHandles.toArray(new JdbcColumnHandle[0]);
        this.readFunctions = new ReadFunction[columnHandles.size()];
        this.booleanReadFunctions = new BooleanReadFunction[columnHandles.size()];
        this.doubleReadFunctions = new DoubleReadFunction[columnHandles.size()];
        this.longReadFunctions = new LongReadFunction[columnHandles.size()];
        this.sliceReadFunctions = new SliceReadFunction[columnHandles.size()];
        this.objectReadFunctions = new ObjectReadFunction[columnHandles.size()];
        try {
            this.connection = jdbcClient.getConnection(session, split);
            for (int i = 0; i < this.columnHandles.length; ++i) {
                ReadFunction readFunction;
                JdbcColumnHandle columnHandle = columnHandles.get(i);
                ColumnMapping columnMapping = jdbcClient.toColumnMapping(session, this.connection, columnHandle.getJdbcTypeHandle()).orElseThrow(() -> new VerifyException("Unsupported column type"));
                Verify.verify((boolean)columnHandle.getColumnType().equals(columnMapping.getType()), (String)"Type mismatch: column handle has type %s but %s is mapped to %s", (Object)columnHandle.getColumnType(), (Object)columnHandle.getJdbcTypeHandle(), (Object)columnMapping.getType());
                Class javaType = columnMapping.getType().getJavaType();
                this.readFunctions[i] = readFunction = columnMapping.getReadFunction();
                if (javaType == Boolean.TYPE) {
                    this.booleanReadFunctions[i] = (BooleanReadFunction)readFunction;
                    continue;
                }
                if (javaType == Double.TYPE) {
                    this.doubleReadFunctions[i] = (DoubleReadFunction)readFunction;
                    continue;
                }
                if (javaType == Long.TYPE) {
                    this.longReadFunctions[i] = (LongReadFunction)readFunction;
                    continue;
                }
                if (javaType == Slice.class) {
                    this.sliceReadFunctions[i] = (SliceReadFunction)readFunction;
                    continue;
                }
                this.objectReadFunctions[i] = (ObjectReadFunction)readFunction;
            }
            this.statement = jdbcClient.buildSql(session, this.connection, split, table, columnHandles);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public Type getType(int field) {
        return this.columnHandles[field].getColumnType();
    }

    public boolean advanceNextPosition() {
        if (this.closed) {
            return false;
        }
        try {
            if (this.resultSet == null) {
                long start = System.nanoTime();
                Future<ResultSet> resultSetFuture = this.executor.submit(() -> {
                    log.debug("Executing: %s", new Object[]{this.statement});
                    return this.statement.executeQuery();
                });
                try {
                    this.resultSet = resultSetFuture.get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof SQLException) {
                        SQLException cause = (SQLException)e.getCause();
                        SQLException sqlException = new SQLException(cause.getMessage(), cause.getSQLState(), cause.getErrorCode(), e);
                        if (cause.getNextException() != null) {
                            sqlException.setNextException(cause.getNextException());
                        }
                        throw sqlException;
                    }
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    resultSetFuture.cancel(true);
                    throw new RuntimeException(e);
                }
                finally {
                    this.readTimeNanos.addAndGet(System.nanoTime() - start);
                }
            }
            return this.resultSet.next();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean getBoolean(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Objects.requireNonNull(this.resultSet, "resultSet is null");
        try {
            return this.booleanReadFunctions[field].readBoolean(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getLong(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Objects.requireNonNull(this.resultSet, "resultSet is null");
        try {
            return this.longReadFunctions[field].readLong(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public double getDouble(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Objects.requireNonNull(this.resultSet, "resultSet is null");
        try {
            return this.doubleReadFunctions[field].readDouble(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Slice getSlice(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Objects.requireNonNull(this.resultSet, "resultSet is null");
        try {
            return this.sliceReadFunctions[field].readSlice(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Object getObject(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Objects.requireNonNull(this.resultSet, "resultSet is null");
        try {
            return this.objectReadFunctions[field].readObject(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean isNull(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Preconditions.checkArgument((field < this.columnHandles.length ? 1 : 0) != 0, (Object)"Invalid field index");
        Objects.requireNonNull(this.resultSet, "resultSet is null");
        try {
            return this.readFunctions[field].isNull(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;
             ResultSet resultSet = this.resultSet;){
            if (statement != null) {
                try {
                    statement.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (connection != null && resultSet != null) {
                this.jdbcClient.abortReadConnection(connection, resultSet);
            }
        }
        catch (RuntimeException | SQLException exception) {
            // empty catch block
        }
    }

    private RuntimeException handleSqlException(Exception e) {
        block2: {
            try {
                this.close();
            }
            catch (Exception closeException) {
                if (e == closeException) break block2;
                e.addSuppressed(closeException);
            }
        }
        return new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
    }
}

