/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.localfile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.localfile.LocalFileErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class DataLocation {
    private final File location;
    private final Optional<String> pattern;

    @JsonCreator
    public DataLocation(@JsonProperty(value="location") String location, @JsonProperty(value="pattern") Optional<String> pattern) {
        Objects.requireNonNull(location, "location is null");
        Objects.requireNonNull(pattern, "pattern is null");
        File file = new File(location);
        if (!file.exists() && pattern.isPresent()) {
            file.mkdirs();
        }
        Preconditions.checkArgument((boolean)file.exists(), (Object)"location does not exist");
        if (pattern.isPresent() && !file.isDirectory()) {
            throw new IllegalArgumentException("pattern may be specified only if location is a directory");
        }
        this.location = file;
        this.pattern = pattern.isEmpty() && file.isDirectory() ? Optional.of("*") : pattern;
    }

    @JsonProperty
    public File getLocation() {
        return this.location;
    }

    @JsonProperty
    public Optional<String> getPattern() {
        return this.pattern;
    }

    public List<File> files() {
        List<File> list;
        block11: {
            Preconditions.checkState((boolean)this.location.exists(), (String)"location %s doesn't exist", (Object)this.location);
            if (this.pattern.isEmpty()) {
                return ImmutableList.of((Object)this.location);
            }
            Preconditions.checkState((boolean)this.location.isDirectory(), (String)"location %s is not a directory", (Object)this.location);
            DirectoryStream<Path> paths = Files.newDirectoryStream(this.location.toPath(), this.pattern.get());
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Path path : paths) {
                    builder.add((Object)path.toFile());
                }
                ImmutableList files = builder.build();
                if (files.isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)LocalFileErrorCode.LOCAL_FILE_NO_FILES, "No matching files found in directory: " + this.location);
                }
                list = files.stream().sorted((o1, o2) -> Long.compare(o2.lastModified(), o1.lastModified())).collect(Collectors.toList());
                if (paths == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)LocalFileErrorCode.LOCAL_FILE_FILESYSTEM_ERROR, "Error listing files in directory: " + this.location, (Throwable)e);
                }
            }
            paths.close();
        }
        return list;
    }
}

