/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.localfile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class LocalFileSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(LocalFileSplit.class).instanceSize());
    private final HostAddress address;

    @JsonCreator
    public LocalFileSplit(@JsonProperty(value="address") HostAddress address) {
        this.address = Objects.requireNonNull(address, "address is null");
    }

    @JsonProperty
    public HostAddress getAddress() {
        return this.address;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)this.address);
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.address.getRetainedSizeInBytes();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
    }
}

