/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import com.clickhouse.jdbc.ClickHouseDriver;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.clickhouse.ClickHouseClient;
import io.trino.plugin.clickhouse.ClickHouseConfig;
import io.trino.plugin.clickhouse.ClickHouseConnectionFactory;
import io.trino.plugin.clickhouse.ClickHouseSessionProperties;
import io.trino.plugin.clickhouse.ClickHouseTableProperties;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import java.sql.Driver;

public class ClickHouseClientModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ClickHouseConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, ClickHouseSessionProperties.class);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(ClickHouseClient.class).in(Scopes.SINGLETON);
        JdbcModule.bindTablePropertiesProvider((Binder)binder, ClickHouseTableProperties.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(JdbcMetadataConfig.class, config -> config.setDomainCompactionThreshold(1000));
        binder.install((Module)new DecimalModule());
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory createConnectionFactory(ClickHouseConfig clickHouseConfig, BaseJdbcConfig config, CredentialProvider credentialProvider) {
        return new ClickHouseConnectionFactory((ConnectionFactory)new DriverConnectionFactory(ClickHouseClientModule.createDriver(clickHouseConfig), config, credentialProvider));
    }

    private static Driver createDriver(ClickHouseConfig config) {
        if (config.isLegacyDriver()) {
            return new ru.yandex.clickhouse.ClickHouseDriver();
        }
        return new ClickHouseDriver();
    }
}

