/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.clickhouse.ClickHouseConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import javax.inject.Inject;

public class ClickHouseSessionProperties
implements SessionPropertiesProvider {
    public static final String MAP_STRING_AS_VARCHAR = "map_string_as_varchar";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public ClickHouseSessionProperties(ClickHouseConfig clickHouseConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)MAP_STRING_AS_VARCHAR, (String)"Map ClickHouse String and FixedString as varchar instead of varbinary", (Boolean)clickHouseConfig.isMapStringAsVarchar(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isMapStringAsVarchar(ConnectorSession session) {
        return (Boolean)session.getProperty(MAP_STRING_AS_VARCHAR, Boolean.class);
    }
}

