/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import com.clickhouse.client.ClickHouseVersion;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TrinoToClickHouseWriteChecker<T> {
    public static final TrinoToClickHouseWriteChecker<Long> UINT8 = new TrinoToClickHouseWriteChecker(ImmutableList.of((Object)new LongWriteValueChecker((Predicate<ClickHouseVersion>)Predicates.alwaysTrue(), new Range<Long>(0L, 255L))));
    public static final TrinoToClickHouseWriteChecker<Long> UINT16 = new TrinoToClickHouseWriteChecker(ImmutableList.of((Object)new LongWriteValueChecker((Predicate<ClickHouseVersion>)Predicates.alwaysTrue(), new Range<Long>(0L, 65535L))));
    public static final TrinoToClickHouseWriteChecker<Long> UINT32 = new TrinoToClickHouseWriteChecker(ImmutableList.of((Object)new LongWriteValueChecker((Predicate<ClickHouseVersion>)Predicates.alwaysTrue(), new Range<Long>(0L, 0xFFFFFFFFL))));
    public static final TrinoToClickHouseWriteChecker<BigDecimal> UINT64 = new TrinoToClickHouseWriteChecker(ImmutableList.of((Object)new BigDecimalWriteValueChecker((Predicate<ClickHouseVersion>)Predicates.alwaysTrue(), new Range<BigDecimal>(BigDecimal.ZERO, new BigDecimal("18446744073709551615")))));
    public static final TrinoToClickHouseWriteChecker<LocalDate> DATE = new TrinoToClickHouseWriteChecker(ImmutableList.of((Object)new DateWriteValueChecker(version -> version.isOlderThan("21.4"), new Range<LocalDate>(LocalDate.parse("1970-01-01"), LocalDate.parse("2106-02-07"))), (Object)new DateWriteValueChecker(version -> version.isNewerOrEqualTo("21.4"), new Range<LocalDate>(LocalDate.parse("1970-01-01"), LocalDate.parse("2149-06-06")))));
    public static final TrinoToClickHouseWriteChecker<LocalDateTime> DATETIME = new TrinoToClickHouseWriteChecker(ImmutableList.of((Object)new TimestampWriteValueChecker(version -> version.isOlderThan("21.4"), new Range<LocalDateTime>(LocalDateTime.parse("1970-01-01T00:00:00"), LocalDateTime.parse("2106-02-06T06:28:15"))), (Object)new TimestampWriteValueChecker(version -> version.isNewerOrEqualTo("21.4"), new Range<LocalDateTime>(LocalDateTime.parse("1970-01-01T00:00:00"), LocalDateTime.parse("2106-02-07T06:28:15")))));
    private final List<Checker<T>> checkers;

    private TrinoToClickHouseWriteChecker(List<Checker<T>> checkers) {
        this.checkers = ImmutableList.copyOf((Collection)Objects.requireNonNull(checkers, "checkers is null"));
    }

    public void validate(ClickHouseVersion version, T value) {
        for (Checker<T> checker : this.checkers) {
            checker.validate(version, value);
        }
    }

    private static interface Checker<T> {
        public void validate(ClickHouseVersion var1, T var2);
    }

    private static class LongWriteValueChecker
    implements Checker<Long> {
        private final Predicate<ClickHouseVersion> predicate;
        private final Range<Long> range;

        public LongWriteValueChecker(Predicate<ClickHouseVersion> predicate, Range<Long> range) {
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
            this.range = Objects.requireNonNull(range, "range is null");
        }

        @Override
        public void validate(ClickHouseVersion version, Long value) {
            if (!this.predicate.test(version)) {
                return;
            }
            if (value >= this.range.getMin() && value <= this.range.getMax()) {
                return;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Value must be between %d and %d in ClickHouse: %d", this.range.getMin(), this.range.getMax(), value));
        }
    }

    private static class Range<T> {
        private final T min;
        private final T max;

        public Range(T min, T max) {
            this.min = Objects.requireNonNull(min, "min is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }
    }

    private static class BigDecimalWriteValueChecker
    implements Checker<BigDecimal> {
        private final Predicate<ClickHouseVersion> predicate;
        private final Range<BigDecimal> range;

        public BigDecimalWriteValueChecker(Predicate<ClickHouseVersion> predicate, Range<BigDecimal> range) {
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
            this.range = Objects.requireNonNull(range, "range is null");
        }

        @Override
        public void validate(ClickHouseVersion version, BigDecimal value) {
            if (!this.predicate.test(version)) {
                return;
            }
            if (value.compareTo(this.range.getMin()) >= 0 && value.compareTo(this.range.getMax()) <= 0) {
                return;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Value must be between %s and %s in ClickHouse: %s", this.range.getMin(), this.range.getMax(), value));
        }
    }

    private static class DateWriteValueChecker
    implements Checker<LocalDate> {
        private final Predicate<ClickHouseVersion> predicate;
        private final Range<LocalDate> range;

        public DateWriteValueChecker(Predicate<ClickHouseVersion> predicate, Range<LocalDate> range) {
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
            this.range = Objects.requireNonNull(range, "range is null");
        }

        @Override
        public void validate(ClickHouseVersion version, LocalDate value) {
            if (!this.predicate.test(version)) {
                return;
            }
            if (value.isBefore(this.range.getMin()) || value.isAfter(this.range.getMax())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Date must be between %s and %s in ClickHouse: %s", this.range.getMin(), this.range.getMax(), value));
            }
        }
    }

    private static class TimestampWriteValueChecker
    implements Checker<LocalDateTime> {
        private final Predicate<ClickHouseVersion> predicate;
        private final Range<LocalDateTime> range;

        public TimestampWriteValueChecker(Predicate<ClickHouseVersion> predicate, Range<LocalDateTime> range) {
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
            this.range = Objects.requireNonNull(range, "range is null");
        }

        @Override
        public void validate(ClickHouseVersion version, LocalDateTime value) {
            if (!this.predicate.test(version)) {
                return;
            }
            if (value.isBefore(this.range.getMin()) || value.isAfter(this.range.getMax())) {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Timestamp must be between %s and %s in ClickHouse: %s", formatter.format(this.range.getMin()), formatter.format(this.range.getMax()), formatter.format(value)));
            }
        }
    }
}

