/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.common.metrics.CachingFileSystemMetrics;
import com.qubole.rubix.common.metrics.CustomMetricsReporterProvider;
import com.qubole.rubix.core.DirectReadRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DirectBufferPool;

public class CachedReadRequestChain
extends ReadRequestChain {
    private String remotePath;
    private long readFromCache;
    private FileSystem.Statistics statistics;
    private FileSystem remoteFileSystem;
    private DirectReadRequestChain directReadChain;
    private Configuration conf;
    private long directDataRead;
    private BookKeeperFactory factory;
    private DirectBufferPool bufferPool;
    private int directBufferSize;
    private int corruptedFileCount;
    private static final Log log = LogFactory.getLog(CachedReadRequestChain.class);

    public CachedReadRequestChain(FileSystem remoteFileSystem, String remotePath, DirectBufferPool bufferPool, int directBufferSize, FileSystem.Statistics statistics, Configuration conf, BookKeeperFactory factory, int generationNumber) {
        super(generationNumber);
        this.conf = conf;
        this.remotePath = remotePath;
        this.remoteFileSystem = remoteFileSystem;
        this.bufferPool = bufferPool;
        this.directBufferSize = directBufferSize;
        this.statistics = statistics;
        this.factory = factory;
    }

    @VisibleForTesting
    public CachedReadRequestChain(FileSystem remoteFileSystem, String remotePath, Configuration conf, BookKeeperFactory factory, int generationNumber) {
        this(remoteFileSystem, remotePath, new DirectBufferPool(), 100, null, conf, factory, generationNumber);
    }

    @VisibleForTesting
    public CachedReadRequestChain() {
        super(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, Cached read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        if (this.readRequests.size() == 0) {
            return 0L;
        }
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        RandomAccessFile raf = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fileChannel = null;
        boolean needsInvalidation = false;
        String localCachedFile = CacheUtil.getLocalPath(this.remotePath, this.conf, this.generationNumber);
        ByteBuffer directBuffer = this.bufferPool.getBuffer(this.directBufferSize);
        try {
            raf = new RandomAccessFile(localCachedFile, "r");
            fis = new FileInputStream(raf.getFD());
            fileChannel = fis.getChannel();
            for (ReadRequest readRequest : this.readRequests) {
                int nread;
                int transferBytes;
                if (this.cancelled) {
                    this.propagateCancel(this.getClass().getName());
                }
                int leftToRead = readRequest.getActualReadLengthIntUnsafe();
                log.debug((Object)String.format("Processing readrequest %d-%d, length %d", readRequest.actualReadStart, readRequest.actualReadEnd, leftToRead));
                for (nread = 0; nread < readRequest.getActualReadLengthIntUnsafe(); nread += transferBytes) {
                    int readInThisCycle = Math.min(leftToRead, directBuffer.capacity());
                    directBuffer.clear();
                    int nbytes = ((FileChannel)fileChannel).read(directBuffer, readRequest.getActualReadStart() + (long)nread);
                    if (nbytes <= 0) break;
                    directBuffer.flip();
                    transferBytes = Math.min(readInThisCycle, nbytes);
                    directBuffer.get(readRequest.getDestBuffer(), readRequest.getDestBufferOffset() + nread, transferBytes);
                    leftToRead -= transferBytes;
                }
                log.debug((Object)String.format("CachedFileRead copied data [%d - %d] at buffer offset %d", readRequest.getActualReadStart(), readRequest.getActualReadStart() + (long)nread, readRequest.getDestBufferOffset()));
                if (nread != readRequest.getActualReadLengthIntUnsafe()) {
                    throw new ReadRequestChain.InvalidationRequiredException(this, "Cached read length didn't match with requested read length for file");
                }
                this.readFromCache += (long)nread;
            }
            log.debug((Object)String.format("Read %d bytes from cached file", this.readFromCache));
        }
        catch (Exception ex) {
            if (ex instanceof ReadRequestChain.CancelledException) {
                throw ex;
            }
            log.error((Object)String.format("Fall back to read from object store for %s .Could not read data from cached file : ", localCachedFile), (Throwable)ex);
            CustomMetricsReporterProvider.getCustomMetricsReporter().addMetric(CachingFileSystemMetrics.LOCAL_FALLBACK_TO_DIRECT_READ);
            needsInvalidation = true;
            this.directDataRead = this.readFromRemoteFileSystem();
            Long l = this.directDataRead;
            return l;
        }
        finally {
            this.bufferPool.returnBuffer(directBuffer);
            if (fis != null) {
                fis.close();
            }
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (raf != null) {
                raf.close();
            }
            if (needsInvalidation) {
                ++this.corruptedFileCount;
                this.invalidateMetadata();
            }
            if (this.statistics != null) {
                this.statistics.incrementBytesRead(this.readFromCache);
            }
        }
        return this.readFromCache;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.directReadChain != null) {
            this.directReadChain.cancel();
        }
    }

    private void invalidateMetadata() {
        try (RetryingPooledBookkeeperClient client = this.factory.createBookKeeperClient(this.conf);){
            client.invalidateFileMetadata(this.remotePath);
        }
        catch (Exception e) {
            log.error((Object)("Could not Invalidate Corrupted File " + this.remotePath + " Error : "), (Throwable)e);
        }
    }

    private long readFromRemoteFileSystem() throws IOException {
        this.readFromCache = 0L;
        if (this.cancelled) {
            return 0L;
        }
        try (FSDataInputStream inputStream = this.remoteFileSystem.open(new Path(this.remotePath));){
            this.directReadChain = new DirectReadRequestChain(inputStream);
            for (ReadRequest readRequest : this.readRequests) {
                this.directReadChain.addReadRequest(readRequest);
            }
            this.directReadChain.lock();
            long directRead = this.directReadChain.call();
            this.directReadChain = null;
            long l = directRead;
            return l;
        }
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setCachedRRCDataRead(this.directDataRead == 0L ? this.readFromCache : 0L).setCachedRRCRequests(this.directDataRead == 0L ? this.requests : 0L).setDirectRRCDataRead(this.directDataRead).setDirectRRCRequests(this.directDataRead == 0L ? 0L : this.requests).setCorruptedFileCount(this.corruptedFileCount);
    }
}

