/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.qubole.rubix.spi.fop.ObjectPool;
import com.qubole.rubix.spi.fop.Poolable;
import java.io.Closeable;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.shaded.TException;
import org.apache.thrift.shaded.TServiceClient;
import org.apache.thrift.shaded.transport.TTransport;

public abstract class RetryingPooledThriftClient
implements Closeable {
    private static final Log log = LogFactory.getLog(RetryingPooledThriftClient.class);
    private final int maxRetries;
    private final Configuration conf;
    private final String host;
    private Poolable<TTransport> transportPoolable;
    protected TServiceClient client;

    public RetryingPooledThriftClient(int maxRetries, Configuration conf, String host, Poolable<TTransport> transportPoolable) {
        this.maxRetries = maxRetries;
        this.conf = conf;
        this.host = host;
        this.transportPoolable = transportPoolable;
    }

    private void updateClient(Poolable<TTransport> transportPoolable) {
        this.client = this.setupClient(transportPoolable);
    }

    public abstract TServiceClient setupClient(Poolable<TTransport> var1);

    protected <V> V retryConnection(Callable<V> callable) throws TException {
        int errors = 0;
        if (this.client == null) {
            this.updateClient(this.transportPoolable);
        }
        while (errors < this.maxRetries) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                log.warn((Object)"Error while connecting : ", (Throwable)e);
                ++errors;
                ObjectPool<TTransport> objectPool = this.transportPoolable.getPool();
                this.transportPoolable.getObject().close();
                this.transportPoolable.getPool().returnObject(this.transportPoolable);
                this.transportPoolable = null;
                this.transportPoolable = objectPool.borrowObject(this.host, this.conf);
                this.updateClient(this.transportPoolable);
            }
        }
        throw new TException();
    }

    @Override
    public void close() {
        if (this.transportPoolable != null) {
            this.transportPoolable.getPool().returnObject(this.transportPoolable);
        }
    }
}

