/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.redis.RedisTableFieldDescription;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RedisTableFieldGroup {
    private final String dataFormat;
    private final List<RedisTableFieldDescription> fields;
    private final String name;

    @JsonCreator
    public RedisTableFieldGroup(@JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<RedisTableFieldDescription> fields) {
        this.dataFormat = Objects.requireNonNull(dataFormat, "dataFormat is null");
        this.name = name;
        this.fields = !dataFormat.equals("set") && !dataFormat.equals("zset") ? ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null")) : null;
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<RedisTableFieldDescription> getFields() {
        return this.fields;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataFormat", (Object)this.dataFormat).add("name", (Object)this.name).add("fields", this.fields).toString();
    }
}

