/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis.decoder.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.RowDecoderFactory;
import io.trino.plugin.redis.RedisFieldDecoder;
import io.trino.plugin.redis.decoder.RedisRowDecoder;
import io.trino.plugin.redis.decoder.hash.HashRedisFieldDecoder;
import io.trino.plugin.redis.decoder.hash.HashRedisRowDecoder;
import io.trino.plugin.redis.decoder.hash.ISO8601HashRedisFieldDecoder;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class HashRedisRowDecoderFactory
implements RowDecoderFactory {
    public RedisRowDecoder create(Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        return new HashRedisRowDecoder(this.chooseFieldDecoders(columns));
    }

    private Map<DecoderColumnHandle, RedisFieldDecoder<String>> chooseFieldDecoders(Set<DecoderColumnHandle> columns) {
        return (Map)columns.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::chooseFieldDecoder));
    }

    private RedisFieldDecoder<String> chooseFieldDecoder(DecoderColumnHandle column) {
        Preconditions.checkArgument((!column.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)column.getName());
        if (column.getDataFormat() == null) {
            return new HashRedisFieldDecoder();
        }
        if (column.getType().getJavaType() == Long.TYPE && "iso8601".equals(column.getDataFormat())) {
            return new ISO8601HashRedisFieldDecoder();
        }
        throw new IllegalArgumentException(String.format("unknown data format '%s' for column '%s'", column.getDataFormat(), column.getName()));
    }
}

