/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis.decoder.hash;

import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.plugin.redis.decoder.hash.HashRedisFieldDecoder;
import io.trino.plugin.redis.decoder.hash.HashRedisValueProvider;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

class ISO8601HashRedisFieldDecoder
extends HashRedisFieldDecoder {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTimeParser().withLocale(Locale.ENGLISH).withChronology((Chronology)ISOChronology.getInstanceUTC()).withOffsetParsed();

    ISO8601HashRedisFieldDecoder() {
    }

    @Override
    public FieldValueProvider decode(String value, DecoderColumnHandle columnHandle) {
        return new ISO8601HashRedisValueProvider(columnHandle, value);
    }

    private static class ISO8601HashRedisValueProvider
    extends HashRedisValueProvider {
        public ISO8601HashRedisValueProvider(DecoderColumnHandle columnHandle, String value) {
            super(columnHandle, value);
        }

        @Override
        public long getLong() {
            DateTime dateTime = FORMATTER.parseDateTime(this.getSlice().toStringAscii());
            long millis = dateTime.getMillis();
            Type type = this.columnHandle.getType();
            if (type.equals(DateType.DATE)) {
                return TimeUnit.MILLISECONDS.toDays(millis);
            }
            if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
                return millis * 1000L;
            }
            if (type.equals(TimeType.TIME_MILLIS)) {
                return millis * 1000000000L;
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
                return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)dateTime.getZone().getID()));
            }
            return millis;
        }
    }
}

