/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpcds.TpcdsSplit;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TpcdsSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final int splitsPerNode;
    private final boolean noSexism;

    public TpcdsSplitManager(NodeManager nodeManager, int splitsPerNode, boolean noSexism) {
        Objects.requireNonNull(nodeManager);
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.nodeManager = nodeManager;
        this.splitsPerNode = splitsPerNode;
        this.noSexism = noSexism;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCDS nodes available");
        int totalParts = nodes.size() * this.splitsPerNode;
        int partNumber = 0;
        List sortedNodes = (List)nodes.stream().sorted(Comparator.comparing(node -> node.getHostAndPort().toString())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node2 : sortedNodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new TpcdsSplit(partNumber, totalParts, (List<HostAddress>)ImmutableList.of((Object)node2.getHostAndPort()), this.noSexism));
                ++partNumber;
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

