/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.QueryableRelBuilder;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;

class LixToRelTranslator {
    final RelOptCluster cluster;
    private final Prepare preparingStmt;
    final JavaTypeFactory typeFactory;

    LixToRelTranslator(RelOptCluster cluster, Prepare preparingStmt) {
        this.cluster = cluster;
        this.preparingStmt = preparingStmt;
        this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
    }

    RelOptTable.ToRelContext toRelContext() {
        if (this.preparingStmt instanceof RelOptTable.ViewExpander) {
            RelOptTable.ViewExpander viewExpander = (RelOptTable.ViewExpander)((Object)this.preparingStmt);
            return ViewExpanders.toRelContext(viewExpander, this.cluster);
        }
        return ViewExpanders.simpleContext(this.cluster);
    }

    public <T> RelNode translate(Queryable<T> queryable) {
        QueryableRelBuilder<T> translatorQueryable = new QueryableRelBuilder<T>(this);
        return translatorQueryable.toRel(queryable);
    }

    public RelNode translate(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)expression;
            BuiltInMethod method = BuiltInMethod.MAP.get(call.method);
            if (method == null) {
                throw new UnsupportedOperationException("unknown method " + call.method);
            }
            switch (method) {
                case SELECT: {
                    RelNode input = this.translate(call.targetExpression);
                    return LogicalProject.create(input, this.toRex(input, (FunctionExpression)call.expressions.get(0)), (List<String>)null);
                }
                case WHERE: {
                    RelNode input = this.translate(call.targetExpression);
                    return LogicalFilter.create(input, this.toRex((FunctionExpression)call.expressions.get(0), input));
                }
                case AS_QUERYABLE: {
                    return LogicalTableScan.create(this.cluster, RelOptTableImpl.create(null, this.typeFactory.createJavaType(Types.toClass(Types.getElementType(call.targetExpression.getType()))), ImmutableList.of(), call.targetExpression));
                }
                case SCHEMA_GET_TABLE: {
                    return LogicalTableScan.create(this.cluster, RelOptTableImpl.create(null, this.typeFactory.createJavaType((Class)((ConstantExpression)call.expressions.get((int)1)).value), ImmutableList.of(), call.targetExpression));
                }
            }
            throw new UnsupportedOperationException("unknown method " + call.method);
        }
        throw new UnsupportedOperationException("unknown expression type " + (Object)((Object)expression.getNodeType()));
    }

    private List<RexNode> toRex(RelNode child, FunctionExpression expression) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        List<RexNode> list = Collections.singletonList(rexBuilder.makeRangeReference(child));
        CalcitePrepareImpl.ScalarTranslator translator = CalcitePrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list);
        ArrayList<RexNode> rexList = new ArrayList<RexNode>();
        Expression simple = Blocks.simple(expression.body);
        for (Expression expression1 : this.fieldExpressions(simple)) {
            rexList.add(translator.toRex(expression1));
        }
        return rexList;
    }

    List<Expression> fieldExpressions(Expression expression) {
        if (expression instanceof NewExpression) {
            return ((NewExpression)expression).arguments;
        }
        throw new RuntimeException("unsupported expression type " + expression);
    }

    List<RexNode> toRexList(FunctionExpression expression, RelNode ... inputs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        for (RelNode input : inputs) {
            list.add(rexBuilder.makeRangeReference(input));
        }
        return CalcitePrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list).toRexList(expression.body);
    }

    RexNode toRex(FunctionExpression expression, RelNode ... inputs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        for (RelNode input : inputs) {
            list.add(rexBuilder.makeRangeReference(input));
        }
        return CalcitePrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list).toRex(expression.body);
    }
}

