/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl.writer;

import io.trino.hive.orc.OrcProto;
import io.trino.hive.orc.TypeDescription;
import io.trino.hive.orc.impl.PositionRecorder;
import io.trino.hive.orc.impl.RunLengthByteWriter;
import io.trino.hive.orc.impl.writer.TreeWriterBase;
import io.trino.hive.orc.impl.writer.WriterContext;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

public class ByteTreeWriter
extends TreeWriterBase {
    private final RunLengthByteWriter writer;

    public ByteTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.writer = new RunLengthByteWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA));
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block6: {
            LongColumnVector vec;
            block5: {
                super.writeBatch(vector, offset, length);
                vec = (LongColumnVector)vector;
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                byte value = (byte)vec.vector[0];
                this.indexStatistics.updateInteger(value, length);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addLong(value);
                    }
                    this.bloomFilterUtf8.addLong(value);
                }
                for (int i = 0; i < length; ++i) {
                    this.writer.write(value);
                }
                break block6;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                byte value = (byte)vec.vector[i + offset];
                this.writer.write(value);
                this.indexStatistics.updateInteger(value, 1);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addLong(value);
                }
                this.bloomFilterUtf8.addLong(value);
            }
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        super.writeStripe(builder, stats, requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.writer.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.writer.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        long num = this.fileStatistics.getNumberOfValues();
        return num * (long)JavaDataModel.get().primitive1();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.writer.flush();
    }
}

