/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client.guice;

import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.drift.client.ExceptionClassifier;
import io.airlift.drift.client.MethodInvocationFilter;
import io.airlift.drift.client.address.AddressSelector;
import io.airlift.drift.client.guice.AddressSelectorBinder;
import io.airlift.drift.client.guice.ExceptionClassifierBinder;
import io.airlift.drift.client.guice.MethodInvocationFilterBinder;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class DriftClientBindingBuilder {
    private final Binder binder;
    private final Annotation annotation;
    private final String prefix;

    DriftClientBindingBuilder(Binder binder, Annotation annotation, String prefix) {
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        this.prefix = Objects.requireNonNull(prefix, "prefix is null");
        this.filterBinder();
        this.classifierBinder();
    }

    public DriftClientBindingBuilder withMethodInvocationFilter(MethodInvocationFilterBinder filterBinder) {
        filterBinder.bind(this.filterBinder(), this.binder, this.annotation, this.prefix);
        return this;
    }

    public DriftClientBindingBuilder withAddressSelector(AddressSelector<?> addressSelector) {
        this.binder.bind(AddressSelector.class).annotatedWith(this.annotation).toInstance(addressSelector);
        return this;
    }

    public DriftClientBindingBuilder withAddressSelector(AddressSelectorBinder selectorBinder) {
        selectorBinder.bind(this.binder, this.annotation, this.prefix);
        return this;
    }

    public DriftClientBindingBuilder withExceptionClassifier(ExceptionClassifier exceptionClassifier) {
        this.classifierBinder().addBinding().toInstance((Object)exceptionClassifier);
        return this;
    }

    public DriftClientBindingBuilder withExceptionClassifier(ExceptionClassifierBinder classifierBinder) {
        classifierBinder.bind(this.classifierBinder(), this.annotation, this.prefix);
        return this;
    }

    private Multibinder<MethodInvocationFilter> filterBinder() {
        return Multibinder.newSetBinder((Binder)this.binder, MethodInvocationFilter.class, (Annotation)this.annotation);
    }

    private Multibinder<ExceptionClassifier> classifierBinder() {
        return Multibinder.newSetBinder((Binder)this.binder, ExceptionClassifier.class, (Annotation)this.annotation);
    }
}

