/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.prometheus.PrometheusColumn;
import io.trino.spi.connector.ColumnMetadata;
import java.util.List;
import java.util.Objects;

public class PrometheusTable {
    private final String name;
    private final List<PrometheusColumn> columns;
    private final List<ColumnMetadata> columnsMetadata;

    @JsonCreator
    public PrometheusTable(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<PrometheusColumn> columns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = Objects.requireNonNull(name, "name is null");
        this.columns = columns;
        ImmutableList.Builder columnsMetadata = ImmutableList.builder();
        for (PrometheusColumn column : this.columns) {
            columnsMetadata.add((Object)new ColumnMetadata(column.getName(), column.getType()));
        }
        this.columnsMetadata = columnsMetadata.build();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<PrometheusColumn> getColumns() {
        return this.columns;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }
}

