/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageMetaStore;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultPageMetaStore
implements PageMetaStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPageMetaStore.class);
    private final Map<PageId, PageInfo> mPageMap = new HashMap<PageId, PageInfo>();
    private final ImmutableList<PageStoreDir> mDirs;
    private final AtomicLong mBytes = new AtomicLong(0L);
    protected final ReentrantReadWriteLock mLock;

    public DefaultPageMetaStore(List<PageStoreDir> dirs) {
        this(dirs, new ReentrantReadWriteLock());
        MetricsSystem.registerGaugeIfAbsent(MetricKey.CLIENT_CACHE_PAGES.getName(), this.mPageMap::size);
    }

    public DefaultPageMetaStore(List<PageStoreDir> dirs, ReentrantReadWriteLock lock) {
        this.mLock = lock;
        this.mDirs = ImmutableList.copyOf(dirs);
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.mLock;
    }

    @Override
    @GuardedBy(value="getLock()")
    public boolean hasPage(PageId pageId) {
        return this.mPageMap.containsKey(pageId);
    }

    @Override
    @GuardedBy(value="getLock()")
    public void addPage(PageId pageId, PageInfo pageInfo) {
        Preconditions.checkArgument(pageId.equals(pageInfo.getPageId()), "page id mismatch");
        this.mPageMap.put(pageId, pageInfo);
        this.mBytes.addAndGet(pageInfo.getPageSize());
        Metrics.SPACE_USED.inc(pageInfo.getPageSize());
        pageInfo.getLocalCacheDir().putPage(pageInfo);
    }

    @Override
    @GuardedBy(value="getLock()")
    public Iterator<PageId> getPagesIterator() {
        return this.mPageMap.keySet().iterator();
    }

    @Override
    public List<PageStoreDir> getStoreDirs() {
        return this.mDirs;
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        if (!this.mPageMap.containsKey(pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = this.mPageMap.get(pageId);
        pageInfo.getLocalCacheDir().getEvictor().updateOnGet(pageId);
        return pageInfo;
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        if (!this.mPageMap.containsKey(pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = this.mPageMap.remove(pageId);
        this.mBytes.addAndGet(-pageInfo.getPageSize());
        Metrics.SPACE_USED.dec(pageInfo.getPageSize());
        pageInfo.getLocalCacheDir().deletePage(pageInfo);
        return pageInfo;
    }

    @Override
    public long bytes() {
        return this.mBytes.get();
    }

    @Override
    @GuardedBy(value="getLock()")
    public long numPages() {
        return this.mPageMap.size();
    }

    @Override
    @GuardedBy(value="getLock()")
    public void reset() {
        this.mBytes.set(0L);
        Metrics.SPACE_USED.dec(Metrics.SPACE_USED.getCount());
        this.mPageMap.clear();
    }

    @Override
    @Nullable
    @GuardedBy(value="getLock()")
    public PageInfo evict(CacheScope scope, PageStoreDir pageStoreDir) {
        return this.evictInternal(pageStoreDir.getEvictor());
    }

    PageInfo evictInternal(CacheEvictor evictor) {
        PageId victim = evictor.evict();
        if (victim == null) {
            return null;
        }
        PageInfo victimInfo = this.mPageMap.get(victim);
        if (victimInfo == null) {
            LOG.error("Invalid result returned by evictor: page {} not available", (Object)victim);
            evictor.updateOnDelete(victim);
            return null;
        }
        return victimInfo;
    }

    private static final class Metrics {
        private static final Counter SPACE_USED = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SPACE_USED_COUNT.getName());

        private Metrics() {
        }
    }
}

