/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.grpc.Block;
import alluxio.grpc.BlockStatus;
import alluxio.proto.dataserver.Protocol;
import alluxio.worker.SessionCleanable;
import alluxio.worker.block.AllocateOptions;
import alluxio.worker.block.BlockStoreEventListener;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.CreateBlockOptions;
import alluxio.worker.block.io.BlockReader;
import alluxio.worker.block.io.BlockWriter;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.TempBlockMeta;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public interface BlockStore
extends Closeable,
SessionCleanable {
    public void abortBlock(long var1, long var3) throws IOException;

    public void accessBlock(long var1, long var3);

    public void commitBlock(long var1, long var3, boolean var5) throws IOException;

    public String createBlock(long var1, long var3, int var5, CreateBlockOptions var6) throws WorkerOutOfSpaceException, IOException;

    public BlockReader createBlockReader(long var1, long var3, long var5, boolean var7, Protocol.OpenUfsBlockOptions var8) throws IOException;

    public BlockReader createUfsBlockReader(long var1, long var3, long var5, boolean var7, Protocol.OpenUfsBlockOptions var8) throws IOException;

    public BlockWriter createBlockWriter(long var1, long var3) throws IOException;

    public BlockStoreMeta getBlockStoreMeta();

    public BlockStoreMeta getBlockStoreMetaFull();

    public Optional<TempBlockMeta> getTempBlockMeta(long var1);

    public boolean hasBlockMeta(long var1);

    public boolean hasTempBlockMeta(long var1);

    public Optional<BlockMeta> getVolatileBlockMeta(long var1);

    public void moveBlock(long var1, long var3, AllocateOptions var5) throws WorkerOutOfSpaceException, IOException;

    public OptionalLong pinBlock(long var1, long var3);

    public void unpinBlock(long var1);

    public void updatePinnedInodes(Set<Long> var1);

    public void registerBlockStoreEventListener(BlockStoreEventListener var1);

    public void removeBlock(long var1, long var3) throws IOException;

    public void removeInaccessibleStorage();

    public void requestSpace(long var1, long var3, long var5) throws WorkerOutOfSpaceException, IOException;

    public List<BlockStatus> load(List<Block> var1, String var2, OptionalLong var3);
}

