/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BigQueryInsertTableHandle
implements ConnectorInsertTableHandle {
    private final RemoteTableName remoteTableName;
    private final List<String> columnNames;
    private final List<Type> columnTypes;

    @JsonCreator
    public BigQueryInsertTableHandle(@JsonProperty(value="remoteTableName") RemoteTableName remoteTableName, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<Type> columnTypes) {
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must have the same size");
    }

    @JsonProperty
    public RemoteTableName getRemoteTableName() {
        return this.remoteTableName;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }
}

