/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryTypeUtils;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class BigQueryPageSink
implements ConnectorPageSink {
    private final BigQueryClient client;
    private final TableId tableId;
    private final List<String> columnNames;
    private final List<Type> columnTypes;

    public BigQueryPageSink(BigQueryClient client, RemoteTableName remoteTableName, List<String> columnNames, List<Type> columnTypes) {
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must have the same size");
        this.tableId = remoteTableName.toTableId();
    }

    public CompletableFuture<?> appendPage(Page page) {
        InsertAllRequest.Builder batch = InsertAllRequest.newBuilder((TableId)this.tableId);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                row.put(this.columnNames.get(channel), BigQueryTypeUtils.readNativeValue(this.columnTypes.get(channel), page.getBlock(channel), position));
            }
            batch.addRow(row);
        }
        this.client.insert(batch.build());
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

