/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryInsertTableHandle;
import io.trino.plugin.bigquery.BigQueryOutputTableHandle;
import io.trino.plugin.bigquery.BigQueryPageSink;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class BigQueryPageSinkProvider
implements ConnectorPageSinkProvider {
    private final BigQueryClientFactory clientFactory;

    @Inject
    public BigQueryPageSinkProvider(BigQueryClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        BigQueryOutputTableHandle handle = (BigQueryOutputTableHandle)outputTableHandle;
        return new BigQueryPageSink(this.clientFactory.createBigQueryClient(session), handle.getRemoteTableName(), handle.getColumnNames(), handle.getColumnTypes());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        BigQueryInsertTableHandle handle = (BigQueryInsertTableHandle)insertTableHandle;
        return new BigQueryPageSink(this.clientFactory.createBigQueryClient(session), handle.getRemoteTableName(), handle.getColumnNames(), handle.getColumnTypes());
    }
}

