/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryEmptyProjectionPageSource;
import io.trino.plugin.bigquery.BigQueryQueryPageSource;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySessionProperties;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.BigQueryStoragePageSource;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class BigQueryPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Logger log = Logger.get(BigQueryPageSourceProvider.class);
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final int maxReadRowsRetries;

    @Inject
    public BigQueryPageSourceProvider(BigQueryClientFactory bigQueryClientFactory, BigQueryReadClientFactory bigQueryReadClientFactory, BigQueryConfig config) {
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory is null");
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory is null");
        this.maxReadRowsRetries = config.getMaxReadRowsRetries();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        log.debug("createPageSource(transaction=%s, session=%s, split=%s, table=%s, columns=%s)", new Object[]{transaction, session, split, table, columns});
        BigQuerySplit bigQuerySplit = (BigQuerySplit)split;
        Preconditions.checkArgument((bigQuerySplit.getColumns().isEmpty() || bigQuerySplit.getColumns().equals(columns) ? 1 : 0) != 0, (String)"Requested columns %s do not match list in split %s", columns, bigQuerySplit.getColumns());
        if (bigQuerySplit.representsEmptyProjection()) {
            return new BigQueryEmptyProjectionPageSource(bigQuerySplit.getEmptyRowsToGenerate());
        }
        List bigQueryColumnHandles = (List)columns.stream().map(BigQueryColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return this.createPageSource(session, (BigQueryTableHandle)table, bigQuerySplit, bigQueryColumnHandles);
    }

    private ConnectorPageSource createPageSource(ConnectorSession session, BigQueryTableHandle table, BigQuerySplit split, List<BigQueryColumnHandle> columnHandles) {
        return switch (split.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case BigQuerySplit.Mode.STORAGE -> this.createStoragePageSource(session, split, columnHandles);
            case BigQuerySplit.Mode.QUERY -> this.createQueryPageSource(session, table, columnHandles, split.getFilter());
        };
    }

    private ConnectorPageSource createStoragePageSource(ConnectorSession session, BigQuerySplit split, List<BigQueryColumnHandle> columnHandles) {
        return new BigQueryStoragePageSource(this.bigQueryReadClientFactory.create(session), this.maxReadRowsRetries, split, columnHandles);
    }

    private ConnectorPageSource createQueryPageSource(ConnectorSession session, BigQueryTableHandle table, List<BigQueryColumnHandle> columnHandles, Optional<String> filter) {
        return new BigQueryQueryPageSource(this.bigQueryClientFactory.create(session), table, (List)columnHandles.stream().map(BigQueryColumnHandle::getName).collect(ImmutableList.toImmutableList()), (List)columnHandles.stream().map(BigQueryType.Adaptor::getTrinoType).collect(ImmutableList.toImmutableList()), filter, BigQuerySessionProperties.isQueryResultsCacheEnabled(session), BigQuerySessionProperties.createDisposition(session));
    }
}

