/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.bigquery.BigQueryNamedRelationHandle;
import io.trino.plugin.bigquery.BigQueryRelationHandle;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BigQueryTableHandle
implements ConnectorTableHandle {
    private final BigQueryRelationHandle relationHandle;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<List<ColumnHandle>> projectedColumns;

    @JsonCreator
    public BigQueryTableHandle(@JsonProperty(value="relationHandle") BigQueryRelationHandle relationHandle, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="projectedColumns") Optional<List<ColumnHandle>> projectedColumns) {
        this.relationHandle = Objects.requireNonNull(relationHandle, "relationHandle is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.projectedColumns = Objects.requireNonNull(projectedColumns, "projectedColumns is null");
    }

    @Deprecated
    public BigQueryTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, TableInfo tableInfo) {
        this(new BigQueryNamedRelationHandle(schemaTableName, remoteTableName, tableInfo.getDefinition().getType().toString(), BigQueryTableHandle.getPartitionType(tableInfo.getDefinition()), Optional.ofNullable(tableInfo.getDescription())));
    }

    public BigQueryTableHandle(BigQueryRelationHandle relationHandle) {
        this(relationHandle, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty());
    }

    @JsonProperty
    public BigQueryRelationHandle getRelationHandle() {
        return this.relationHandle;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<List<ColumnHandle>> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonIgnore
    public BigQueryNamedRelationHandle getRequiredNamedRelation() {
        Preconditions.checkState((boolean)this.isNamedRelation(), (String)"The table handle does not represent a named relation: %s", (Object)this);
        return (BigQueryNamedRelationHandle)this.relationHandle;
    }

    @JsonIgnore
    public boolean isSynthetic() {
        return !this.isNamedRelation();
    }

    @JsonIgnore
    public boolean isNamedRelation() {
        return this.relationHandle instanceof BigQueryNamedRelationHandle;
    }

    public BigQueryNamedRelationHandle asPlainTable() {
        Preconditions.checkState((!this.isSynthetic() ? 1 : 0) != 0, (String)"The table handle does not represent a plain table: %s", (Object)this);
        return this.getRequiredNamedRelation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryTableHandle that = (BigQueryTableHandle)o;
        return Objects.equals(this.relationHandle, that.relationHandle) && Objects.equals(this.constraint, that.constraint) && Objects.equals(this.projectedColumns, that.projectedColumns);
    }

    public int hashCode() {
        return Objects.hash(this.relationHandle, this.constraint, this.projectedColumns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relationHandle", (Object)this.relationHandle).add("constraint", this.constraint).add("projectedColumns", this.projectedColumns).toString();
    }

    BigQueryTableHandle withConstraint(TupleDomain<ColumnHandle> newConstraint) {
        return new BigQueryTableHandle(this.relationHandle, newConstraint, this.projectedColumns);
    }

    public BigQueryTableHandle withProjectedColumns(List<ColumnHandle> newProjectedColumns) {
        return new BigQueryTableHandle(this.relationHandle, this.constraint, Optional.of(newProjectedColumns));
    }

    public static Optional<BigQueryPartitionType> getPartitionType(TableDefinition definition) {
        if (definition instanceof StandardTableDefinition) {
            StandardTableDefinition standardTableDefinition = (StandardTableDefinition)definition;
            RangePartitioning rangePartition = standardTableDefinition.getRangePartitioning();
            if (rangePartition != null) {
                return Optional.of(BigQueryPartitionType.RANGE);
            }
            TimePartitioning timePartition = standardTableDefinition.getTimePartitioning();
            if (timePartition != null) {
                if (timePartition.getField() != null) {
                    return Optional.of(BigQueryPartitionType.TIME);
                }
                return Optional.of(BigQueryPartitionType.INGESTION);
            }
        }
        return Optional.empty();
    }

    public static enum BigQueryPartitionType {
        TIME,
        INGESTION,
        RANGE;

    }
}

