/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mysql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.mysql.cj.jdbc.JdbcStatement;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcJoinPushdownUtil;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementStddevPop;
import io.trino.plugin.jdbc.aggregation.ImplementStddevSamp;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.aggregation.ImplementVariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementVarianceSamp;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.mysql.ImplementAvgBigint;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class MySqlClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(MySqlClient.class);
    private static final int MAX_SUPPORTED_DATE_TIME_PRECISION = 6;
    private static final int ZERO_PRECISION_TIMESTAMP_COLUMN_SIZE = 19;
    private static final int ZERO_PRECISION_TIME_COLUMN_SIZE = 8;
    private static final String NO_COMMENT = "";
    private static final JsonCodec<ColumnHistogram> HISTOGRAM_CODEC = JsonCodec.jsonCodec(ColumnHistogram.class);
    private static final Estimate UNKNOWN_NULL_FRACTION_REPLACEMENT = Estimate.of((double)0.1);
    private final Type jsonType;
    private final boolean statisticsEnabled;
    private final ConnectorExpressionRewriter<String> connectorExpressionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, String> aggregateFunctionRewriter;

    @Inject
    public MySqlClient(BaseJdbcConfig config, JdbcStatisticsConfig statisticsConfig, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, TypeManager typeManager, IdentifierMapping identifierMapping) {
        super(config, "`", connectionFactory, queryBuilder, identifierMapping, true);
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.statisticsEnabled = statisticsConfig.isEnabled();
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((MySqlClient)this).quoted(arg_0)).build();
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax(false)).add((Object)new ImplementSum(MySqlClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).build());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return MySqlClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    public Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getCatalogs();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_CAT");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        if (schemaName.equalsIgnoreCase("mysql") || schemaName.equalsIgnoreCase("sys")) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    public void abortReadConnection(Connection connection, ResultSet resultSet) throws SQLException {
        if (!resultSet.isAfterLast()) {
            connection.abort(MoreExecutors.directExecutor());
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        if (statement.isWrapperFor(JdbcStatement.class)) {
            statement.unwrap(JdbcStatement.class).enableStreamingResults();
        }
        return statement;
    }

    public ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(schemaName.orElse(null), null, this.escapeObjectNameForMetadataQuery(tableName, metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    public Optional<String> getTableComment(ResultSet resultSet) throws SQLException {
        return Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
    }

    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        String sql = String.format("ALTER TABLE %s COMMENT = %s", this.quoted(handle.asPlainTable().getRemoteTableName()), MySqlClient.mysqlVarcharLiteral(comment.orElse(NO_COMMENT)));
        this.execute(session, sql);
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    protected String createTableSql(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        return String.format("CREATE TABLE %s (%s) COMMENT %s", this.quoted(remoteTableName), String.join((CharSequence)", ", columns), MySqlClient.mysqlVarcharLiteral(tableMetadata.getComment().orElse(NO_COMMENT)));
    }

    private static String mysqlVarcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''").replace("\\", "\\\\") + "'";
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName.toLowerCase(Locale.ENGLISH)) {
            case "tinyint unsigned": {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case "smallint unsigned": {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case "int unsigned": {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case "bigint unsigned": {
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)20)));
            }
            case "json": {
                return Optional.of(this.jsonColumnMapping());
            }
            case "enum": {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
        }
        switch (typeHandle.getJdbcType()) {
            case -7: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), (LongWriteFunction)StandardColumnMappings.realWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
                int precision = typeHandle.getRequiredColumnSize();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if ((precision += Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (SliceReadFunction)StandardColumnMappings.varbinaryReadFunction(), (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMappingUsingLocalDate());
            }
            case 92: {
                TimeType timeType = TimeType.createTimeType((int)MySqlClient.getTimePrecision(typeHandle.getRequiredColumnSize()));
                return Optional.of(StandardColumnMappings.timeColumnMapping((TimeType)timeType));
            }
            case 93: {
                TimestampType timestampType = TimestampType.createTimestampType((int)MySqlClient.getTimestampPrecision(typeHandle.getRequiredColumnSize()));
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)timestampType));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return MySqlClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private static int getTimestampPrecision(int timestampColumnSize) {
        if (timestampColumnSize == 19) {
            return 0;
        }
        int timestampPrecision = timestampColumnSize - 19 - 1;
        Verify.verify((1 <= timestampPrecision && timestampPrecision <= 6 ? 1 : 0) != 0, (String)"Unexpected timestamp precision %s calculated from timestamp column size %s", (int)timestampPrecision, (int)timestampColumnSize);
        return timestampPrecision;
    }

    private static int getTimePrecision(int timeColumnSize) {
        if (timeColumnSize == 8) {
            return 0;
        }
        int timePrecision = timeColumnSize - 8 - 1;
        Verify.verify((1 <= timePrecision && timePrecision <= 6 ? 1 : 0) != 0, (String)"Unexpected time precision %s calculated from time column size %s", (int)timePrecision, (int)timeColumnSize);
        return timePrecision;
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunctionUsingLocalDate());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            if (timeType.getPrecision() <= 6) {
                return WriteMapping.longMapping((String)String.format("time(%s)", timeType.getPrecision()), (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)timeType.getPrecision()));
            }
            return WriteMapping.longMapping((String)String.format("time(%s)", 6), (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)6));
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.getPrecision() <= 6) {
                Verify.verify((timestampType.getPrecision() <= 6 ? 1 : 0) != 0);
                return WriteMapping.longMapping((String)String.format("datetime(%s)", timestampType.getPrecision()), (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)timestampType));
            }
            return WriteMapping.objectMapping((String)String.format("datetime(%s)", 6), (ObjectWriteFunction)StandardColumnMappings.longTimestampWriteFunction((TimestampType)timestampType, (int)6));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"mediumblob", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("char(" + charType.getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            String dataType = varcharType.isUnbounded() ? "longtext" : (varcharType.getBoundedLength() <= 255 ? "tinytext" : (varcharType.getBoundedLength() <= 65535 ? "text" : (varcharType.getBoundedLength() <= 0xFFFFFF ? "mediumtext" : "longtext")));
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type.equals(this.jsonType)) {
            return WriteMapping.sliceMapping((String)"json", (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = "42S01".equals(e.getSQLState());
            throw new TrinoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    protected void renameColumn(ConnectorSession session, Connection connection, RemoteTableName remoteTableName, String remoteColumnName, String newRemoteColumnName) throws SQLException {
        String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.quoted(remoteColumnName), this.quoted(newRemoteColumnName));
        this.execute(connection, sql);
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String tableCopyFormat = "CREATE TABLE %s AS SELECT * FROM %s WHERE 0 = 1";
        if (MySqlClient.isGtidMode(connection)) {
            tableCopyFormat = "CREATE TABLE %s LIKE %s";
        }
        String sql = String.format(tableCopyFormat, this.quoted(catalogName, schemaName, newTableName), this.quoted(catalogName, schemaName, tableName));
        try {
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        Verify.verify((boolean)remoteTableName.getSchemaName().isEmpty());
        this.renameTable(session, null, remoteTableName.getCatalogName().orElse(null), remoteTableName.getTableName(), newTableName);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.getColumn().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().flatMap(sortItem -> {
                String ordering = sortItem.getSortOrder().isAscending() ? "ASC" : "DESC";
                String columnSorting = String.format("%s %s", this.quoted(sortItem.getColumn().getColumnName()), ordering);
                switch (sortItem.getSortOrder()) {
                    case ASC_NULLS_FIRST: 
                    case DESC_NULLS_LAST: {
                        return Stream.of(columnSorting);
                    }
                    case ASC_NULLS_LAST: {
                        return Stream.of(String.format("ISNULL(%s) ASC", this.quoted(sortItem.getColumn().getColumnName())), columnSorting);
                    }
                    case DESC_NULLS_FIRST: {
                        return Stream.of(String.format("ISNULL(%s) DESC", this.quoted(sortItem.getColumn().getColumnName())), columnSorting);
                    }
                }
                throw new UnsupportedOperationException("Unsupported sort order: " + sortItem.getSortOrder());
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %s", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return JdbcJoinPushdownUtil.implementJoinCostAware((ConnectorSession)session, (JoinType)joinType, (PreparedQuery)leftSource, (PreparedQuery)rightSource, (JoinStatistics)statistics, () -> super.implementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics));
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IS_DISTINCT_FROM) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        if (!this.statisticsEnabled) {
            return TableStatistics.empty();
        }
        if (!handle.isNamedRelation()) {
            return TableStatistics.empty();
        }
        try {
            return this.readTableStatistics(session, handle);
        }
        catch (RuntimeException | SQLException e) {
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed fetching statistics for table: " + handle, (Throwable)e);
        }
    }

    private TableStatistics readTableStatistics(ConnectorSession session, JdbcTableHandle table) throws SQLException {
        Preconditions.checkArgument((boolean)table.isNamedRelation(), (String)"Relation is not a table: %s", (Object)table);
        log.debug("Reading statistics for %s", new Object[]{table});
        try (Connection connection = this.connectionFactory.openConnection(session);){
            TableStatistics tableStatistics;
            block24: {
                Map<String, ColumnIndexStatistics> columnStatisticsFromIndexes;
                Map<String, String> columnHistograms;
                TableStatistics.Builder tableStatistics2;
                Long rowCount;
                Handle handle;
                block22: {
                    TableStatistics tableStatistics3;
                    block23: {
                        StatisticsDao statisticsDao;
                        block20: {
                            TableStatistics tableStatistics4;
                            block21: {
                                handle = Jdbi.open((Connection)connection);
                                statisticsDao = new StatisticsDao(handle);
                                rowCount = statisticsDao.getRowCount(table);
                                log.debug("Estimated row count of table %s is %s", new Object[]{table, rowCount});
                                if (rowCount != null) break block20;
                                tableStatistics4 = TableStatistics.empty();
                                if (handle == null) break block21;
                                handle.close();
                            }
                            return tableStatistics4;
                        }
                        tableStatistics2 = TableStatistics.builder();
                        tableStatistics2.setRowCount(Estimate.of((double)rowCount.longValue()));
                        columnHistograms = statisticsDao.getColumnHistograms(table);
                        columnStatisticsFromIndexes = statisticsDao.getColumnIndexStatistics(table);
                        if (!columnHistograms.isEmpty() || !columnStatisticsFromIndexes.isEmpty()) break block22;
                        log.debug("No column histograms and index statistics read");
                        tableStatistics3 = tableStatistics2.build();
                        if (handle == null) break block23;
                        handle.close();
                    }
                    return tableStatistics3;
                }
                try {
                    for (JdbcColumnHandle column : this.getColumns(session, table)) {
                        ColumnStatistics columnStatistics;
                        ColumnIndexStatistics columnIndexStatistics;
                        ColumnStatistics.Builder columnStatisticsBuilder = ColumnStatistics.builder();
                        String columnName = column.getColumnName();
                        Optional<ColumnHistogram> histogram = MySqlClient.getColumnHistogram(columnHistograms, columnName);
                        if (histogram.isPresent()) {
                            log.debug("Reading column statistics for %s, %s from histogram: %s", new Object[]{table, columnName, columnHistograms.get(columnName)});
                            histogram.get().updateColumnStatistics(columnStatisticsBuilder);
                            rowCount = histogram.get().getUpdateRowCount(rowCount);
                        }
                        if ((columnIndexStatistics = columnStatisticsFromIndexes.get(columnName)) != null) {
                            log.debug("Reading column statistics for %s, %s from index statistics: %s", new Object[]{table, columnName, columnIndexStatistics});
                            MySqlClient.updateColumnStatisticsFromIndexStatistics(table, columnName, columnStatisticsBuilder, columnIndexStatistics);
                            rowCount = Math.max(rowCount, columnIndexStatistics.getCardinality());
                        }
                        if (!(columnStatistics = columnStatisticsBuilder.build()).getDistinctValuesCount().isUnknown() && columnStatistics.getNullsFraction().isUnknown()) {
                            columnStatisticsBuilder.setNullsFraction(UNKNOWN_NULL_FRACTION_REPLACEMENT);
                            columnStatistics = columnStatisticsBuilder.build();
                        }
                        tableStatistics2.setColumnStatistics((ColumnHandle)column, columnStatistics);
                    }
                    tableStatistics2.setRowCount(Estimate.of((double)rowCount.longValue()));
                    tableStatistics = tableStatistics2.build();
                    if (handle == null) break block24;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return tableStatistics;
        }
    }

    private static Optional<ColumnHistogram> getColumnHistogram(Map<String, String> columnHistograms, String columnName) {
        return Optional.ofNullable(columnHistograms.get(columnName)).flatMap(histogramJson -> {
            try {
                return Optional.of((ColumnHistogram)HISTOGRAM_CODEC.fromJson(histogramJson));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to parse column statistics histogram: %s", new Object[]{histogramJson});
                return Optional.empty();
            }
        });
    }

    private static void updateColumnStatisticsFromIndexStatistics(JdbcTableHandle table, String columnName, ColumnStatistics.Builder columnStatistics, ColumnIndexStatistics columnIndexStatistics) {
        columnStatistics.setDistinctValuesCount(Estimate.of((double)columnIndexStatistics.getCardinality()));
        if (!columnIndexStatistics.nullable) {
            double knownNullFraction = columnStatistics.build().getNullsFraction().getValue();
            if (knownNullFraction > 0.0) {
                log.warn("Inconsistent statistics, null fraction for a column %s, %s, that is not nullable according to index statistics: %s", new Object[]{table, columnName, knownNullFraction});
            }
            columnStatistics.setNullsFraction(Estimate.zero());
        }
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isGtidMode(Connection connection) {
        try (Statement statement = connection.createStatement();){
            boolean bl;
            block18: {
                ResultSet resultSet;
                block16: {
                    boolean bl2;
                    block17: {
                        resultSet = statement.executeQuery("SHOW VARIABLES LIKE 'gtid_mode'");
                        try {
                            if (!resultSet.next()) break block16;
                            boolean bl3 = bl2 = !resultSet.getString("Value").equalsIgnoreCase("OFF");
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return bl2;
                }
                bl = false;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static class StatisticsDao {
        private final Handle handle;

        public StatisticsDao(Handle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        Long getRowCount(JdbcTableHandle table) {
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return ((Query)((Query)this.handle.createQuery("SELECT TABLE_ROWS FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = :schema AND TABLE_NAME = :table_name AND TABLE_TYPE = 'BASE TABLE' ").bind("schema", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).mapTo(Long.class).findOne().orElse(null);
        }

        Map<String, ColumnIndexStatistics> getColumnIndexStatistics(JdbcTableHandle table) {
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return (Map)((Query)((Query)this.handle.createQuery("SELECT   COLUMN_NAME,   MAX(NULLABLE) AS NULLABLE,   MAX(CARDINALITY) AS CARDINALITY FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = :schema AND TABLE_NAME = :table_name AND SEQ_IN_INDEX = 1 AND SUB_PART IS NULL AND CARDINALITY IS NOT NULL GROUP BY COLUMN_NAME").bind("schema", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).map((rs, ctx) -> {
                String columnName = rs.getString("COLUMN_NAME");
                boolean nullable = rs.getString("NULLABLE").equalsIgnoreCase("YES");
                Preconditions.checkState((!rs.wasNull() ? 1 : 0) != 0, (Object)"NULLABLE is null");
                long cardinality = rs.getLong("CARDINALITY");
                Preconditions.checkState((!rs.wasNull() ? 1 : 0) != 0, (Object)"CARDINALITY is null");
                return new AbstractMap.SimpleEntry<String, ColumnIndexStatistics>(columnName, new ColumnIndexStatistics(nullable, cardinality));
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        Map<String, String> getColumnHistograms(JdbcTableHandle table) {
            block2: {
                try {
                    this.handle.execute("SELECT 1 FROM INFORMATION_SCHEMA.COLUMN_STATISTICS WHERE 0=1", new Object[0]);
                }
                catch (UnableToExecuteStatementException e) {
                    if (!(e.getCause() instanceof SQLSyntaxErrorException) || ((SQLSyntaxErrorException)e.getCause()).getErrorCode() != 1109) break block2;
                    log.debug("INFORMATION_SCHEMA.COLUMN_STATISTICS table is not available: %s", new Object[]{e});
                    return ImmutableMap.of();
                }
            }
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return (Map)((Query)((Query)this.handle.createQuery("SELECT COLUMN_NAME, HISTOGRAM FROM INFORMATION_SCHEMA.COLUMN_STATISTICS WHERE SCHEMA_NAME = :schema AND TABLE_NAME = :table_name").bind("schema", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).map((rs, ctx) -> new AbstractMap.SimpleEntry<String, String>(rs.getString("COLUMN_NAME"), rs.getString("HISTOGRAM"))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static class ColumnHistogram {
        private final Optional<Double> nullFraction;
        private final Optional<String> histogramType;
        private final Optional<List<List<Object>>> buckets;

        @JsonCreator
        public ColumnHistogram(@JsonProperty(value="null-values") Optional<Double> nullFraction, @JsonProperty(value="histogram-type") Optional<String> histogramType, @JsonProperty(value="buckets") Optional<List<List<Object>>> buckets) {
            this.nullFraction = nullFraction;
            this.histogramType = histogramType;
            this.buckets = buckets;
        }

        public void updateColumnStatistics(ColumnStatistics.Builder columnStatistics) {
            this.nullFraction.map(Estimate::of).ifPresent(arg_0 -> ((ColumnStatistics.Builder)columnStatistics).setNullsFraction(arg_0));
            this.getDistinctValuesCount().map(Estimate::of).ifPresent(arg_0 -> ((ColumnStatistics.Builder)columnStatistics).setDistinctValuesCount(arg_0));
        }

        private Optional<Long> getDistinctValuesCount() {
            if (this.histogramType.isPresent() && this.buckets.isPresent()) {
                switch (this.histogramType.get()) {
                    case "singleton": {
                        return Optional.of(Long.valueOf(this.buckets.get().size()));
                    }
                    case "equi-height": {
                        long distinctValues = 0L;
                        for (List<Object> bucket : this.buckets.get()) {
                            distinctValues += ((Number)bucket.get(3)).longValue();
                        }
                        return Optional.of(distinctValues);
                    }
                }
                log.debug("Unsupported histogram type: %s", new Object[]{this.histogramType.get()});
            } else {
                log.debug("Unsupported histogram: type: %s, bucket count: %s", new Object[]{this.histogramType, this.buckets.map(List::size)});
            }
            return Optional.empty();
        }

        public long getUpdateRowCount(long rowCount) {
            return this.getDistinctValuesCount().map(distinctValuesCount -> Math.max(rowCount, distinctValuesCount)).orElse(rowCount);
        }
    }

    private static class ColumnIndexStatistics {
        private final boolean nullable;
        private final long cardinality;

        public ColumnIndexStatistics(boolean nullable, long cardinality) {
            this.cardinality = cardinality;
            this.nullable = nullable;
        }

        public long getCardinality() {
            return this.cardinality;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cardinality", this.getCardinality()).add("nullable", this.nullable).toString();
        }
    }
}

