/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.Duration;
import io.trino.hdfs.ConfigurationUtils;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.ConcurrentLazyQueue;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HivePartitionMetadata;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveSplitLoader;
import io.trino.plugin.hive.HiveSplitSource;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.InternalHiveSplit;
import io.trino.plugin.hive.NamenodeStats;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.HiveFileIterator;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.s3select.S3SelectPushdown;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.InternalHiveSplitFactory;
import io.trino.plugin.hive.util.PartitionMatchSupplier;
import io.trino.plugin.hive.util.ResumableTask;
import io.trino.plugin.hive.util.ResumableTasks;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.TextInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final Pattern BUCKET_WITH_OPTIONAL_ATTEMPT_ID_PATTERN = Pattern.compile("bucket_(\\d+)(_\\d+)?$");
    private static final Iterable<Pattern> BUCKET_PATTERNS = ImmutableList.of((Object)Pattern.compile("\\d{8}_\\d{6}_\\d{5}_[a-z0-9]{5}_bucket-(\\d+)(?:[-_.].*)?"), (Object)Pattern.compile("(\\d+)_\\d+.*"), (Object)BUCKET_WITH_OPTIONAL_ATTEMPT_ID_PATTERN);
    private static final ListenableFuture<Void> COMPLETED_FUTURE = Futures.immediateVoidFuture();
    private final Table table;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final DynamicFilter dynamicFilter;
    private final long dynamicFilteringWaitTimeoutMillis;
    private final TypeManager typeManager;
    private final Optional<BucketSplitInfo> tableBucketInfo;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final int loaderConcurrency;
    private final boolean recursiveDirWalkerEnabled;
    private final boolean ignoreAbsentPartitions;
    private final boolean optimizeSymlinkListing;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators = new ConcurrentLinkedDeque<Iterator<InternalHiveSplit>>();
    private final Optional<ValidWriteIdList> validWriteIds;
    private final Optional<Long> maxSplitFileSize;
    private final int maxPartitions;
    private final ReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private Stopwatch stopwatch;
    private volatile boolean stopped;
    private final AtomicInteger activeLoaderCount = new AtomicInteger();
    private final AtomicInteger partitionCount = new AtomicInteger();

    public BackgroundHiveSplitLoader(Table table, Iterator<HivePartitionMetadata> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, DynamicFilter dynamicFilter, Duration dynamicFilteringWaitTimeout, TypeManager typeManager, Optional<BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled, boolean ignoreAbsentPartitions, boolean optimizeSymlinkListing, Optional<ValidWriteIdList> validWriteIds, Optional<Long> maxSplitFileSize, int maxPartitions) {
        this.table = table;
        this.compactEffectivePredicate = compactEffectivePredicate;
        this.dynamicFilter = dynamicFilter;
        this.dynamicFilteringWaitTimeoutMillis = dynamicFilteringWaitTimeout.toMillis();
        this.typeManager = typeManager;
        this.tableBucketInfo = tableBucketInfo;
        this.loaderConcurrency = loaderConcurrency;
        Preconditions.checkArgument((loaderConcurrency > 0 ? 1 : 0) != 0, (String)"loaderConcurrency must be > 0, found: %s", (int)loaderConcurrency);
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.ignoreAbsentPartitions = ignoreAbsentPartitions;
        this.optimizeSymlinkListing = optimizeSymlinkListing;
        Objects.requireNonNull(executor, "executor is null");
        BackgroundHiveSplitLoader.checkExecutorIsNotDirectExecutor(executor);
        this.executor = executor;
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(partitions);
        this.hdfsContext = new HdfsContext(session);
        this.validWriteIds = Objects.requireNonNull(validWriteIds, "validWriteIds is null");
        this.maxSplitFileSize = Objects.requireNonNull(maxSplitFileSize, "maxSplitFileSize is null");
        this.maxPartitions = maxPartitions;
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        this.stopwatch = Stopwatch.createStarted();
        this.addLoaderIfNecessary();
    }

    private void addLoaderIfNecessary() {
        if (this.activeLoaderCount.get() >= this.loaderConcurrency) {
            return;
        }
        if (this.activeLoaderCount.incrementAndGet() > this.loaderConcurrency) {
            return;
        }
        ListenableFuture<Void> future = ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        MoreFutures.addExceptionCallback(future, this.hiveSplitSource::fail);
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        this.taskExecutionLock.readLock().lock();
        try {
            if (!this.partitions.isEmpty() || !this.fileIterators.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
            return;
        }
        finally {
            this.taskExecutionLock.readLock().unlock();
        }
        this.taskExecutionLock.writeLock().lock();
        try {
            if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                this.hiveSplitSource.noMoreSplits();
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
        }
        finally {
            this.taskExecutionLock.writeLock().unlock();
        }
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Void> loadSplits() throws IOException {
        Iterator<InternalHiveSplit> splits = this.fileIterators.poll();
        if (splits == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            if (this.partitionCount.incrementAndGet() > this.maxPartitions) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getHivePartition().getTableName(), this.maxPartitions));
            }
            if (!this.partitions.isEmpty()) {
                this.addLoaderIfNecessary();
            }
            return this.loadPartition(partition);
        }
        if (!this.fileIterators.isEmpty()) {
            this.addLoaderIfNecessary();
        }
        while (splits.hasNext() && !this.stopped) {
            ListenableFuture<Void> future = this.hiveSplitSource.addToQueue(splits.next());
            if (future.isDone()) continue;
            this.fileIterators.addFirst(splits);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<Void> loadPartition(HivePartitionMetadata partition) throws IOException {
        HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId;
        Object readPaths;
        Object baseOrDeltaPath;
        boolean splittable;
        HivePartition hivePartition = partition.getHivePartition();
        String partitionName = hivePartition.getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain effectivePredicate = this.compactEffectivePredicate.transformKeys(HiveColumnHandle.class::cast);
        BooleanSupplier partitionMatchSupplier = PartitionMatchSupplier.createPartitionMatchSupplier(this.dynamicFilter, hivePartition, HiveUtil.getPartitionKeyColumnHandles(this.table, this.typeManager));
        if (!partitionMatchSupplier.getAsBoolean()) {
            return COMPLETED_FUTURE;
        }
        Path path = new Path(MetastoreUtil.getPartitionLocation(this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
        FileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        boolean s3SelectPushdownEnabled = S3SelectPushdown.shouldEnablePushdownForTable(this.session, this.table, path.toString(), partition.getPartition());
        boolean shouldEnableSplits = S3SelectPushdown.isSplittable(s3SelectPushdownEnabled, schema, inputFormat, path);
        boolean bl = splittable = shouldEnableSplits && HiveUtil.getFooterCount(schema) == 0 && HiveUtil.getHeaderCount(schema) <= 1;
        if (inputFormat instanceof SymlinkTextInputFormat) {
            Optional<Iterator<InternalHiveSplit>> manifestFileIterator;
            if (this.tableBucketInfo.isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            InputFormat<?, ?> targetInputFormat = HiveUtil.getInputFormat(configuration, schema, true);
            List targetPaths = (List)this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity(), () -> BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path));
            Set parents = (Set)targetPaths.stream().map(Path::getParent).distinct().collect(ImmutableSet.toImmutableSet());
            if (this.optimizeSymlinkListing && parents.size() == 1 && !this.recursiveDirWalkerEnabled && (manifestFileIterator = this.buildManifestFileIterator(targetInputFormat, partitionName, schema, partitionKeys, (TupleDomain<HiveColumnHandle>)effectivePredicate, partitionMatchSupplier, s3SelectPushdownEnabled, partition.getTableToPartitionMapping(), (Path)Iterables.getOnlyElement((Iterable)parents), targetPaths, splittable)).isPresent()) {
                this.fileIterators.addLast(manifestFileIterator.get());
                return COMPLETED_FUTURE;
            }
            return this.createHiveSymlinkSplits(partitionName, targetInputFormat, schema, partitionKeys, (TupleDomain<HiveColumnHandle>)effectivePredicate, partitionMatchSupplier, s3SelectPushdownEnabled, partition.getTableToPartitionMapping(), targetPaths);
        }
        Optional<HiveSplit.BucketConversion> bucketConversion = Optional.empty();
        boolean bucketConversionRequiresWorkerParticipation = false;
        if (partition.getPartition().isPresent()) {
            Optional<HiveBucketProperty> partitionBucketProperty = partition.getPartition().get().getStorage().getBucketProperty();
            if (this.tableBucketInfo.isPresent() && partitionBucketProperty.isPresent()) {
                int tableBucketCount = this.tableBucketInfo.get().getTableBucketCount();
                HiveBucketing.BucketingVersion bucketingVersion = partitionBucketProperty.get().getBucketingVersion();
                int partitionBucketCount = partitionBucketProperty.get().getBucketCount();
                if (tableBucketCount != partitionBucketCount) {
                    bucketConversion = Optional.of(new HiveSplit.BucketConversion(bucketingVersion, tableBucketCount, partitionBucketCount, this.tableBucketInfo.get().getBucketColumns()));
                    if (tableBucketCount > partitionBucketCount) {
                        bucketConversionRequiresWorkerParticipation = true;
                    }
                }
            }
        }
        Optional<HiveSplit.BucketValidation> bucketValidation = Optional.empty();
        if (HiveSessionProperties.isValidateBucketing(this.session) && this.tableBucketInfo.isPresent()) {
            BucketSplitInfo info = this.tableBucketInfo.get();
            bucketValidation = Optional.of(new HiveSplit.BucketValidation(info.getBucketingVersion(), info.getTableBucketCount(), info.getBucketColumns()));
        }
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(fs, partitionName, inputFormat, schema, partitionKeys, (TupleDomain<HiveColumnHandle>)effectivePredicate, partitionMatchSupplier, partition.getTableToPartitionMapping(), bucketConversionRequiresWorkerParticipation ? bucketConversion : Optional.empty(), bucketValidation, HiveSessionProperties.getMaxInitialSplitSize(this.session), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled, this.maxSplitFileSize);
        if (BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            if (this.tableBucketInfo.isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Trino cannot read bucketed partition in an input format with UseFileSplitsFromInputFormat annotation: " + inputFormat.getClass().getSimpleName());
            }
            if (AcidUtils.isTransactionalTable(this.table.getParameters())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive transactional tables in an input format with UseFileSplitsFromInputFormat annotation are not supported: " + inputFormat.getClass().getSimpleName());
            }
            JobConf jobConf = ConfigurationUtils.toJobConf((Configuration)configuration);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
            Maps.fromProperties((Properties)schema).forEach((arg_0, arg_1) -> ((JobConf)jobConf).set(arg_0, arg_1));
            InputSplit[] splits = (InputSplit[])this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity(), () -> inputFormat.getSplits(jobConf, 0));
            return this.addSplitsToSource(splits, splitFactory);
        }
        Object fileStatusOriginalFiles = ImmutableList.of();
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder(path);
        boolean isFullAcid = AcidUtils.isFullAcidTable(this.table.getParameters());
        if (AcidUtils.isTransactionalTable(this.table.getParameters())) {
            AcidUtils.Directory directory = (AcidUtils.Directory)this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity(), () -> AcidUtils.getAcidState((Path)path, (Configuration)configuration, (ValidWriteIdList)this.validWriteIds.orElseThrow(() -> new IllegalStateException("No validWriteIds present")), (boolean)false, (boolean)true));
            if (isFullAcid) {
                Object object = directory.getBaseDirectory() != null ? directory.getBaseDirectory() : (baseOrDeltaPath = directory.getCurrentDirectories().size() > 0 ? ((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(0)).getPath() : null);
                if (baseOrDeltaPath != null && AcidUtils.OrcAcidVersion.getAcidVersionFromMetaFile((Path)baseOrDeltaPath, (FileSystem)fs) >= 2) {
                    acidInfoBuilder.setOrcAcidVersionValidated(true);
                }
            }
            readPaths = new ArrayList();
            if (directory.getBaseDirectory() != null) {
                readPaths.add(directory.getBaseDirectory());
            }
            for (AcidUtils.ParsedDelta delta : directory.getCurrentDirectories()) {
                if (delta.isDeleteDelta()) continue;
                readPaths.add(delta.getPath());
            }
            for (AcidUtils.ParsedDelta delta : directory.getCurrentDirectories()) {
                if (!delta.isDeleteDelta()) continue;
                if (!isFullAcid) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Unexpected delete delta for a non full ACID table '%s'. Would be ignored by the reader: %s", this.table.getSchemaTableName(), delta.getPath()));
                }
                acidInfoBuilder.addDeleteDelta(delta.getPath());
            }
            fileStatusOriginalFiles = directory.getOriginalFiles();
            baseOrDeltaPath = fileStatusOriginalFiles.iterator();
            while (baseOrDeltaPath.hasNext()) {
                hdfsFileStatusWithId = (HadoopShims.HdfsFileStatusWithId)baseOrDeltaPath.next();
                Path originalFilePath = hdfsFileStatusWithId.getFileStatus().getPath();
                long originalFileLength = hdfsFileStatusWithId.getFileStatus().getLen();
                if (originalFileLength == 0L) continue;
                int bucketId = BackgroundHiveSplitLoader.getRequiredBucketNumber(originalFilePath);
                acidInfoBuilder.addOriginalFile(originalFilePath, originalFileLength, bucketId);
            }
        } else {
            acidInfoBuilder.setOrcAcidVersionValidated(true);
            readPaths = ImmutableList.of((Object)path);
        }
        if (this.tableBucketInfo.isPresent()) {
            ListenableFuture<Void> lastResult = Futures.immediateVoidFuture();
            baseOrDeltaPath = readPaths.iterator();
            while (baseOrDeltaPath.hasNext()) {
                Path readPath = (Path)baseOrDeltaPath.next();
                ArrayList<TrinoFileStatus> files = new ArrayList<TrinoFileStatus>();
                try {
                    Iterators.addAll(files, (Iterator)((Object)new HiveFileIterator(this.table, readPath, fs, this.directoryLister, this.namenodeStats, HiveFileIterator.NestedDirectoryPolicy.FAIL, this.ignoreAbsentPartitions)));
                }
                catch (HiveFileIterator.NestedDirectoryNotAllowedException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. Found sub-directory '%s' in bucket directory for partition: %s", this.table.getSchemaTableName(), e.getNestedDirectoryPath(), splitFactory.getPartitionName()));
                }
                Optional<AcidInfo> acidInfo = isFullAcid ? acidInfoBuilder.build() : Optional.empty();
                lastResult = this.hiveSplitSource.addToQueue(this.getBucketedSplits(files, splitFactory, this.tableBucketInfo.get(), bucketConversion, splittable, acidInfo));
            }
            baseOrDeltaPath = fileStatusOriginalFiles.iterator();
            while (baseOrDeltaPath.hasNext()) {
                hdfsFileStatusWithId = (HadoopShims.HdfsFileStatusWithId)baseOrDeltaPath.next();
                ImmutableList fileStatuses = ImmutableList.of((Object)new TrinoFileStatus((LocatedFileStatus)hdfsFileStatusWithId.getFileStatus()));
                Optional<AcidInfo> acidInfo = isFullAcid ? Optional.of(acidInfoBuilder.buildWithRequiredOriginalFiles(BackgroundHiveSplitLoader.getRequiredBucketNumber(hdfsFileStatusWithId.getFileStatus().getPath()))) : Optional.empty();
                lastResult = this.hiveSplitSource.addToQueue(this.getBucketedSplits((List<TrinoFileStatus>)fileStatuses, splitFactory, this.tableBucketInfo.get(), bucketConversion, splittable, acidInfo));
            }
            return lastResult;
        }
        Iterator iterator = readPaths.iterator();
        while (iterator.hasNext()) {
            Path readPath = (Path)iterator.next();
            Optional<AcidInfo> acidInfo = isFullAcid ? acidInfoBuilder.build() : Optional.empty();
            this.fileIterators.addLast(this.createInternalHiveSplitIterator(readPath, fs, splitFactory, splittable, acidInfo));
        }
        if (!fileStatusOriginalFiles.isEmpty()) {
            this.fileIterators.addLast(this.generateOriginalFilesSplits(splitFactory, (List<HadoopShims.HdfsFileStatusWithId>)fileStatusOriginalFiles, splittable, acidInfoBuilder, isFullAcid));
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<Void> createHiveSymlinkSplits(String partitionName, InputFormat<?, ?> targetInputFormat, Properties schema, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, BooleanSupplier partitionMatchSupplier, boolean s3SelectPushdownEnabled, TableToPartitionMapping tableToPartitionMapping, List<Path> targetPaths) throws IOException {
        ListenableFuture<Void> lastResult = COMPLETED_FUTURE;
        for (Path targetPath : targetPaths) {
            FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetPath);
            JobConf targetJob = ConfigurationUtils.toJobConf((Configuration)targetFilesystem.getConf());
            targetJob.setInputFormat(TextInputFormat.class);
            Optional principal = this.hdfsContext.getIdentity().getPrincipal();
            if (principal.isPresent()) {
                targetJob.set("mapreduce.framework.name", "classic");
                targetJob.set("mapreduce.jobtracker.kerberos.principal", ((Principal)principal.get()).getName());
            }
            if (targetInputFormat instanceof JobConfigurable) {
                ((JobConfigurable)targetInputFormat).configure(targetJob);
            }
            FileInputFormat.setInputPaths((JobConf)targetJob, (Path[])new Path[]{targetPath});
            InputSplit[] targetSplits = (InputSplit[])this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity(), () -> targetInputFormat.getSplits(targetJob, 0));
            InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(targetFilesystem, partitionName, targetInputFormat, schema, partitionKeys, effectivePredicate, partitionMatchSupplier, tableToPartitionMapping, Optional.empty(), Optional.empty(), HiveSessionProperties.getMaxInitialSplitSize(this.session), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled, this.maxSplitFileSize);
            lastResult = this.addSplitsToSource(targetSplits, splitFactory);
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    @VisibleForTesting
    Optional<Iterator<InternalHiveSplit>> buildManifestFileIterator(InputFormat<?, ?> targetInputFormat, String partitionName, Properties schema, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, BooleanSupplier partitionMatchSupplier, boolean s3SelectPushdownEnabled, TableToPartitionMapping tableToPartitionMapping, Path parent, List<Path> paths, boolean splittable) throws IOException {
        FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, parent);
        HashMap fileStatuses = new HashMap();
        HiveFileIterator fileStatusIterator = new HiveFileIterator(this.table, parent, targetFilesystem, this.directoryLister, this.namenodeStats, HiveFileIterator.NestedDirectoryPolicy.IGNORED, false);
        fileStatusIterator.forEachRemaining(status -> fileStatuses.put(Path.getPathWithoutSchemeAndAuthority((Path)status.getPath()), status));
        ArrayList<TrinoFileStatus> locatedFileStatuses = new ArrayList<TrinoFileStatus>();
        for (Path path : paths) {
            TrinoFileStatus status2 = (TrinoFileStatus)fileStatuses.get(Path.getPathWithoutSchemeAndAuthority((Path)path));
            if (status2 == null) {
                return Optional.empty();
            }
            locatedFileStatuses.add(status2);
        }
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(targetFilesystem, partitionName, targetInputFormat, schema, partitionKeys, effectivePredicate, partitionMatchSupplier, tableToPartitionMapping, Optional.empty(), Optional.empty(), HiveSessionProperties.getMaxInitialSplitSize(this.session), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled, this.maxSplitFileSize);
        return Optional.of(locatedFileStatuses.stream().map(locatedFileStatus -> splitFactory.createInternalHiveSplit((TrinoFileStatus)locatedFileStatus, OptionalInt.empty(), OptionalInt.empty(), splittable, Optional.empty())).filter(Optional::isPresent).map(Optional::get).iterator());
    }

    private Iterator<InternalHiveSplit> generateOriginalFilesSplits(InternalHiveSplitFactory splitFactory, List<HadoopShims.HdfsFileStatusWithId> originalFileLocations, boolean splittable, AcidInfo.Builder acidInfoBuilder, boolean isFullAcid) {
        return originalFileLocations.stream().map(HadoopShims.HdfsFileStatusWithId::getFileStatus).map(fileStatus -> {
            Optional<AcidInfo> acidInfo = isFullAcid ? Optional.of(acidInfoBuilder.buildWithRequiredOriginalFiles(BackgroundHiveSplitLoader.getRequiredBucketNumber(fileStatus.getPath()))) : Optional.empty();
            return splitFactory.createInternalHiveSplit(new TrinoFileStatus((LocatedFileStatus)fileStatus), OptionalInt.empty(), OptionalInt.empty(), splittable, acidInfo);
        }).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    private ListenableFuture<Void> addSplitsToSource(InputSplit[] targetSplits, InternalHiveSplitFactory splitFactory) throws IOException {
        ListenableFuture<Void> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            Optional<InternalHiveSplit> internalHiveSplit = splitFactory.createInternalHiveSplit((FileSplit)inputSplit);
            if (internalHiveSplit.isPresent()) {
                lastResult = this.hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private Iterator<InternalHiveSplit> createInternalHiveSplitIterator(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, boolean splittable, Optional<AcidInfo> acidInfo) {
        return Streams.stream((Iterator)((Object)new HiveFileIterator(this.table, path, fileSystem, this.directoryLister, this.namenodeStats, this.recursiveDirWalkerEnabled ? HiveFileIterator.NestedDirectoryPolicy.RECURSE : HiveFileIterator.NestedDirectoryPolicy.IGNORED, this.ignoreAbsentPartitions))).map(status -> splitFactory.createInternalHiveSplit((TrinoFileStatus)status, OptionalInt.empty(), OptionalInt.empty(), splittable, acidInfo)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    private List<InternalHiveSplit> getBucketedSplits(List<TrinoFileStatus> files, InternalHiveSplitFactory splitFactory, BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion, boolean splittable, Optional<AcidInfo> acidInfo) {
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.map(HiveSplit.BucketConversion::getPartitionBucketCount).orElse(tableBucketCount);
        int bucketCount = Math.max(readBucketCount, partitionBucketCount);
        Preconditions.checkState((readBucketCount <= tableBucketCount ? 1 : 0) != 0, (String)"readBucketCount(%s) should be less than or equal to tableBucketCount(%s)", (int)readBucketCount, (int)tableBucketCount);
        ArrayListMultimap bucketFiles = ArrayListMultimap.create();
        for (TrinoFileStatus file : files) {
            String fileName = file.getPath().getName();
            OptionalInt bucket = BackgroundHiveSplitLoader.getBucketNumber(fileName);
            if (bucket.isPresent()) {
                bucketFiles.put((Object)bucket.getAsInt(), (Object)file);
                continue;
            }
            if (files.size() != partitionBucketCount) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. File '%s' does not match the standard naming pattern, and the number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", this.table.getSchemaTableName(), fileName, files.size(), partitionBucketCount, splitFactory.getPartitionName()));
            }
            files.sort(null);
            bucketFiles.clear();
            for (int i = 0; i < files.size(); ++i) {
                bucketFiles.put((Object)i, (Object)files.get(i));
            }
        }
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap<Integer, TrinoFileStatus>)bucketFiles, partitionBucketCount, this.table.getSchemaTableName().toString(), splitFactory.getPartitionName());
        ArrayList<InternalHiveSplit> splitList = new ArrayList<InternalHiveSplit>();
        for (int bucketNumber = 0; bucketNumber < bucketCount; ++bucketNumber) {
            int partitionBucketNumber = bucketNumber % partitionBucketCount;
            int readBucketNumber = bucketNumber % readBucketCount;
            boolean containsIneligibleTableBucket = false;
            ArrayList<Integer> eligibleTableBucketNumbers = new ArrayList<Integer>();
            for (int tableBucketNumber2 = bucketNumber % tableBucketCount; tableBucketNumber2 < tableBucketCount; tableBucketNumber2 += bucketCount) {
                if (bucketSplitInfo.isTableBucketEnabled(tableBucketNumber2)) {
                    eligibleTableBucketNumbers.add(tableBucketNumber2);
                    continue;
                }
                containsIneligibleTableBucket = true;
            }
            if (!eligibleTableBucketNumbers.isEmpty() && containsIneligibleTableBucket) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The bucket filter cannot be satisfied. There are restrictions on the bucket filter when all the following is true: 1. a table has a different buckets count as at least one of its partitions that is read in this query; 2. the table has a different but compatible bucket number with another table in the query; 3. some buckets of the table is filtered out from the query, most likely using a filter on \"$bucket\". (table name: " + this.table.getTableName() + ", table bucket count: " + tableBucketCount + ", partition bucket count: " + partitionBucketCount + ", effective reading bucket count: " + readBucketCount + ")");
            }
            if (eligibleTableBucketNumbers.isEmpty()) continue;
            for (TrinoFileStatus file : bucketFiles.get((Object)partitionBucketNumber)) {
                eligibleTableBucketNumbers.stream().map(tableBucketNumber -> splitFactory.createInternalHiveSplit(file, OptionalInt.of(readBucketNumber), OptionalInt.of(tableBucketNumber), splittable, acidInfo)).forEach(optionalSplit -> optionalSplit.ifPresent(splitList::add));
            }
        }
        return splitList;
    }

    @VisibleForTesting
    static void validateFileBuckets(ListMultimap<Integer, TrinoFileStatus> bucketFiles, int partitionBucketCount, String tableName, String partitionName) {
        if (bucketFiles.isEmpty()) {
            return;
        }
        int highestBucketNumber = (Integer)Collections.max(bucketFiles.keySet());
        if (highestBucketNumber >= partitionBucketCount) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. The highest bucket number in the directory (%s) exceeds the bucket number range defined by the declared bucket count (%s) for partition: %s", tableName, highestBucketNumber, partitionBucketCount, partitionName));
        }
    }

    private static int getRequiredBucketNumber(Path path) {
        return BackgroundHiveSplitLoader.getBucketNumber(path.getName()).orElseThrow(() -> new IllegalStateException("Cannot get bucket number from path: " + path));
    }

    @VisibleForTesting
    static OptionalInt getBucketNumber(String name) {
        for (Pattern pattern : BUCKET_PATTERNS) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            return OptionalInt.of(Integer.parseInt(matcher.group(1)));
        }
        return OptionalInt.empty();
    }

    public static boolean hasAttemptId(String bucketFilename) {
        Matcher matcher = BUCKET_WITH_OPTIONAL_ATTEMPT_ID_PATTERN.matcher(bucketFilename);
        return matcher.matches() && matcher.group(2) != null;
    }

    private static List<Path> getTargetPathsFromSymlink(FileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (partition.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List<Column> keys = table.getPartitionColumns();
        List<String> values = partition.get().getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            HiveType hiveType = keys.get(i).getType();
            if (!hiveType.isSupportedType(table.getStorage().getStorageFormat())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        if (partition.isEmpty()) {
            return MetastoreUtil.getHiveSchema(table);
        }
        return MetastoreUtil.getHiveSchema(partition.get(), table);
    }

    private static void checkExecutorIsNotDirectExecutor(Executor executor) {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            executor.execute(() -> Preconditions.checkState((!lock.isHeldByCurrentThread() ? 1 : 0) != 0, (Object)"executor is a direct executor"));
        }
        finally {
            lock.unlock();
        }
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            ListenableFuture<Void> future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                long timeLeft = BackgroundHiveSplitLoader.this.dynamicFilteringWaitTimeoutMillis - BackgroundHiveSplitLoader.this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (timeLeft > 0L && BackgroundHiveSplitLoader.this.dynamicFilter.isAwaitable()) {
                    future = BackgroundHiveSplitLoader.asVoid(MoreFutures.toListenableFuture(((CompletableFuture)BackgroundHiveSplitLoader.this.dynamicFilter.isBlocked().thenApply(Function.identity())).orTimeout(timeLeft, TimeUnit.MILLISECONDS)));
                    return ResumableTask.TaskStatus.continueOn(future);
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.loadSplits();
                }
                catch (Throwable e2) {
                    TrinoException e2;
                    if (e2 instanceof IOException) {
                        e2 = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, e2);
                    } else if (!(e2 instanceof TrinoException)) {
                        e2 = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, e2);
                    }
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e2);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }

    public static class BucketSplitInfo {
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final List<HiveColumnHandle> bucketColumns;
        private final int tableBucketCount;
        private final int readBucketCount;
        private final IntPredicate bucketFilter;

        public static Optional<BucketSplitInfo> createBucketSplitInfo(Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            Objects.requireNonNull(bucketHandle, "bucketHandle is null");
            Objects.requireNonNull(bucketFilter, "bucketFilter is null");
            if (bucketHandle.isEmpty()) {
                Preconditions.checkArgument((boolean)bucketFilter.isEmpty(), (Object)"bucketHandle must be present if bucketFilter is present");
                return Optional.empty();
            }
            HiveBucketing.BucketingVersion bucketingVersion = bucketHandle.get().getBucketingVersion();
            int tableBucketCount = bucketHandle.get().getTableBucketCount();
            int readBucketCount = bucketHandle.get().getReadBucketCount();
            List<HiveColumnHandle> bucketColumns = bucketHandle.get().getColumns();
            IntPredicate predicate = bucketFilter.map(filter -> filter.getBucketsToKeep()::contains).orElse(bucket -> true);
            return Optional.of(new BucketSplitInfo(bucketingVersion, bucketColumns, tableBucketCount, readBucketCount, predicate));
        }

        private BucketSplitInfo(HiveBucketing.BucketingVersion bucketingVersion, List<HiveColumnHandle> bucketColumns, int tableBucketCount, int readBucketCount, IntPredicate bucketFilter) {
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
            this.tableBucketCount = tableBucketCount;
            this.readBucketCount = readBucketCount;
            this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        }

        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getReadBucketCount() {
            return this.readBucketCount;
        }

        public boolean isTableBucketEnabled(int tableBucketNumber) {
            return this.bucketFilter.test(tableBucketNumber);
        }
    }
}

