/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.spi.expression.FunctionName;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import java.util.Optional;

public enum HiveColumnStatisticType {
    MIN_VALUE(new FunctionName("min")),
    MAX_VALUE(new FunctionName("max")),
    NUMBER_OF_DISTINCT_VALUES(new FunctionName("approx_distinct")),
    NUMBER_OF_NON_NULL_VALUES(new FunctionName("count")),
    NUMBER_OF_TRUE_VALUES(new FunctionName("count_if")),
    MAX_VALUE_SIZE_IN_BYTES(ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES),
    TOTAL_SIZE_IN_BYTES(ColumnStatisticType.TOTAL_SIZE_IN_BYTES);

    private final Optional<ColumnStatisticType> columnStatisticType;
    private final Optional<FunctionName> aggregationName;

    private HiveColumnStatisticType(ColumnStatisticType columnStatisticType) {
        this.columnStatisticType = Optional.of(columnStatisticType);
        this.aggregationName = Optional.empty();
    }

    private HiveColumnStatisticType(FunctionName aggregationName) {
        this.columnStatisticType = Optional.empty();
        this.aggregationName = Optional.of(aggregationName);
    }

    public ColumnStatisticMetadata createColumnStatisticMetadata(String columnName) {
        String connectorAggregationId = this.name();
        if (this.columnStatisticType.isPresent()) {
            return new ColumnStatisticMetadata(columnName, connectorAggregationId, this.columnStatisticType.get());
        }
        return new ColumnStatisticMetadata(columnName, connectorAggregationId, this.aggregationName.orElseThrow());
    }

    public static HiveColumnStatisticType from(ColumnStatisticMetadata columnStatisticMetadata) {
        return HiveColumnStatisticType.valueOf(columnStatisticMetadata.getConnectorAggregationId());
    }
}

