/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.event.client.EventClient;
import io.airlift.units.DataSize;
import io.trino.hdfs.ConfigurationUtils;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionCodecs;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.HiveWriter;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.MergeFileWriter;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.RecordFileWriter;
import io.trino.plugin.hive.SortingFileWriter;
import io.trino.plugin.hive.WriteCompletedEvent;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.util.CompressionConfigUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.Page;
import io.trino.spi.PageSorter;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ReflectionUtil;
import org.joda.time.DateTimeZone;

public class HiveWriterFactory {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private static final Pattern BUCKET_FROM_FILENAME_PATTERN = Pattern.compile("(0[0-9]+)_.*");
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final String schemaName;
    private final String tableName;
    private final AcidTransaction transaction;
    private final List<HiveColumnHandle> inputColumns;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final Map<String, String> additionalTableParameters;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String queryId;
    private final boolean isCreateTransactionalTable;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final PageSorter pageSorter;
    private final JobConf conf;
    private final Table table;
    private final DataSize sortBufferSize;
    private final int maxOpenSortFiles;
    private final boolean sortedWritingTempStagingPathEnabled;
    private final String sortedWritingTempStagingPath;
    private final HiveSessionProperties.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior;
    private final DateTimeZone parquetTimeZone;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final List<SortingColumn> sortedBy;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final Map<String, String> sessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final Optional<Type> rowType;
    private final Optional<HiveType> hiveRowtype;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, AcidTransaction transaction, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, Map<String, String> additionalTableParameters, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String queryId, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, DateTimeZone parquetTimeZone, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats) {
        Path writePath;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.inputColumns = Objects.requireNonNull(inputColumns, "inputColumns is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.additionalTableParameters = ImmutableMap.copyOf(Objects.requireNonNull(additionalTableParameters, "additionalTableParameters is null"));
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.sortBufferSize = Objects.requireNonNull(sortBufferSize, "sortBufferSize is null");
        this.maxOpenSortFiles = maxOpenSortFiles;
        this.sortedWritingTempStagingPathEnabled = HiveSessionProperties.isTemporaryStagingDirectoryEnabled(session);
        this.sortedWritingTempStagingPath = HiveSessionProperties.getTemporaryStagingDirectoryPath(session);
        this.insertExistingPartitionsBehavior = HiveSessionProperties.getInsertExistingPartitionsBehavior(session);
        this.parquetTimeZone = Objects.requireNonNull(parquetTimeZone, "parquetTimeZone is null");
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column2 : inputColumns) {
            HiveType hiveType = column2.getHiveType();
            if (column2.isPartitionKey()) {
                partitionColumnNames.add((Object)column2.getName());
                partitionColumnTypes.add((Object)column2.getType());
                continue;
            }
            dataColumns.add((Object)new DataColumn(column2.getName(), hiveType));
        }
        if (transaction.isMerge()) {
            RowType mergeRowType = RowType.from((List)((List)inputColumns.stream().filter(column -> !column.isPartitionKey()).map(column -> new RowType.Field(Optional.of(column.getName()), column.getType())).collect(ImmutableList.toImmutableList())));
            this.rowType = Optional.of(mergeRowType);
            this.hiveRowtype = Optional.of(HiveType.toHiveType((Type)mergeRowType));
        } else {
            this.rowType = Optional.empty();
            this.hiveRowtype = Optional.empty();
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        boolean bl = this.isCreateTransactionalTable = isCreateTable && transaction.isTransactional();
        if (isCreateTable) {
            this.table = null;
            LocationService.WriteInfo writeInfo = locationService.getQueryWriteInfo(locationHandle);
            Preconditions.checkArgument((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"CREATE TABLE write mode cannot be DIRECT_TO_TARGET_EXISTING_DIRECTORY");
            writePath = writeInfo.getWritePath();
        } else {
            this.table = pageSinkMetadataProvider.getTable().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' was dropped during insert", schemaName, tableName)));
            writePath = locationService.getQueryWriteInfo(locationHandle).getWritePath();
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (String)"bucketCount must be smaller than %s", (int)100000);
        }
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.sessionProperties = (Map)hiveSessionProperties.getSessionProperties().stream().map(propertyMetadata -> Maps.immutableEntry((Object)propertyMetadata.getName(), (Object)session.getProperty(propertyMetadata.getName(), propertyMetadata.getJavaType()))).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        Configuration conf = hdfsEnvironment.getConfiguration(new HdfsContext(session), writePath);
        this.conf = ConfigurationUtils.toJobConf((Configuration)conf);
        try {
            hdfsEnvironment.getFileSystem(session.getIdentity(), writePath, conf);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + writePath, (Throwable)e);
        }
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
    }

    public HiveWriter createWriter(Page partitionColumns, int position, OptionalInt bucketNumber) {
        Object fileNameWithExtension;
        Path path;
        int bucketToUse;
        StorageFormat outputStorageFormat;
        LocationService.WriteInfo writeInfo;
        Properties schema;
        PartitionUpdate.UpdateMode updateMode;
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((boolean)bucketNumber.isEmpty(), (Object)"Bucket number provided by for table that is not bucketed");
        }
        List<String> partitionValues = HiveWriteUtils.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Object> partition = Optional.empty();
        if (!partitionValues.isEmpty() && this.table != null) {
            partition = this.pageSinkMetadataProvider.getPartition(partitionValues);
        }
        JobConf outputConf = new JobConf((Configuration)this.conf);
        if (partition.isEmpty()) {
            if (this.table == null) {
                updateMode = PartitionUpdate.UpdateMode.NEW;
                schema = new Properties();
                schema.setProperty("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.setProperty("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
                if (partitionName.isEmpty()) {
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                } else {
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    if (!writeInfo.getWriteMode().isWritePathSameAsTargetPath() && HiveWriteUtils.pathExists(new HdfsContext(this.session), this.hdfsEnvironment, writeInfo.getTargetPath())) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, writeInfo.getTargetPath()));
                    }
                }
            } else {
                if (partitionName.isPresent()) {
                    updateMode = PartitionUpdate.UpdateMode.NEW;
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                } else {
                    switch (this.insertExistingPartitionsBehavior) {
                        case APPEND: {
                            updateMode = PartitionUpdate.UpdateMode.APPEND;
                            writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                            break;
                        }
                        case OVERWRITE: {
                            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
                            writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, true);
                            break;
                        }
                        case ERROR: {
                            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_READ_ONLY, "Unpartitioned Hive tables are immutable");
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported insert existing table behavior: " + this.insertExistingPartitionsBehavior);
                        }
                    }
                }
                schema = MetastoreUtil.getHiveSchema(this.table);
            }
            if (partitionName.isPresent()) {
                outputStorageFormat = StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat);
                CompressionConfigUtil.configureCompression((Configuration)outputConf, HiveCompressionCodecs.selectCompressionCodec(this.session, this.partitionStorageFormat));
            } else {
                outputStorageFormat = StorageFormat.fromHiveStorageFormat(this.tableStorageFormat);
                CompressionConfigUtil.configureCompression((Configuration)outputConf, HiveCompressionCodecs.selectCompressionCodec(this.session, this.tableStorageFormat));
            }
        } else {
            switch (this.insertExistingPartitionsBehavior) {
                case APPEND: {
                    updateMode = PartitionUpdate.UpdateMode.APPEND;
                    List<Column> tableColumns = this.table.getDataColumns();
                    List<Column> existingPartitionColumns = ((Partition)partition.get()).getColumns();
                    for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
                        HiveType partitionType;
                        HiveType tableType = tableColumns.get(i).getType();
                        if (tableType.equals(partitionType = existingPartitionColumns.get(i).getType())) continue;
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("You are trying to write into an existing partition in a table. The table schema has changed since the creation of the partition. Inserting rows into such partition is not supported. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), this.tableName, tableType, partitionName, existingPartitionColumns.get(i).getName(), partitionType));
                    }
                    HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), (Partition)partition.get());
                    outputStorageFormat = ((Partition)partition.get()).getStorage().getStorageFormat();
                    CompressionConfigUtil.configureCompression((Configuration)outputConf, HiveCompressionCodecs.selectCompressionCodec(this.session, outputStorageFormat));
                    schema = MetastoreUtil.getHiveSchema((Partition)partition.get(), this.table);
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    break;
                }
                case OVERWRITE: {
                    updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
                    outputStorageFormat = StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat);
                    CompressionConfigUtil.configureCompression((Configuration)outputConf, HiveCompressionCodecs.selectCompressionCodec(this.session, this.partitionStorageFormat));
                    schema = MetastoreUtil.getHiveSchema(this.table);
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), (String)partitionName.get());
                    break;
                }
                case ERROR: {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + (String)partitionName.get());
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported insert existing partitions behavior: %s", new Object[]{this.insertExistingPartitionsBehavior}));
                }
            }
        }
        CompressionConfigUtil.assertCompressionConfigured((Configuration)outputConf);
        this.additionalTableParameters.forEach(schema::setProperty);
        this.validateSchema(partitionName, schema);
        int n = bucketToUse = bucketNumber.isEmpty() ? 0 : bucketNumber.getAsInt();
        if (this.transaction.isAcidTransactionRunning() && this.transaction.getOperation() != AcidOperation.CREATE_TABLE) {
            String subdir = this.computeAcidSubdir(this.transaction);
            Path subdirPath = new Path(writeInfo.getWritePath(), subdir);
            String nameFormat = this.table != null && AcidUtils.isInsertOnlyTable(this.table.getParameters()) ? "%05d_0" : "bucket_%05d";
            path = new Path(subdirPath, String.format(nameFormat, bucketToUse));
            fileNameWithExtension = path.getName();
        } else {
            String fileName = this.computeFileName(bucketNumber);
            fileNameWithExtension = fileName + HiveWriterFactory.getFileExtension(outputConf, outputStorageFormat);
            path = new Path(writeInfo.getWritePath(), (String)fileNameWithExtension);
        }
        boolean useAcidSchema = this.isCreateTransactionalTable || this.table != null && AcidUtils.isFullAcidTable(this.table.getParameters());
        Object hiveFileWriter = null;
        if (this.transaction.isMerge()) {
            OrcFileWriterFactory orcFileWriterFactory = (OrcFileWriterFactory)this.fileWriterFactories.stream().filter(factory -> factory instanceof OrcFileWriterFactory).findFirst().get();
            Preconditions.checkArgument((boolean)this.hiveRowtype.isPresent(), (Object)"rowTypes not present");
            RowIdSortingFileWriterMaker fileWriterMaker = (deleteWriter, deletePath) -> this.makeRowIdSortingWriter(deleteWriter, deletePath);
            hiveFileWriter = new MergeFileWriter(this.transaction, 0, bucketNumber, fileWriterMaker, path, partitionName, orcFileWriterFactory, this.inputColumns, (Configuration)this.conf, this.session, this.typeManager, this.hiveRowtype.get());
        } else {
            for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
                Optional<FileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, outputConf, this.session, bucketNumber, this.transaction, useAcidSchema, WriterKind.INSERT);
                if (!fileWriter.isPresent()) continue;
                hiveFileWriter = fileWriter.get();
                break;
            }
        }
        if (hiveFileWriter == null) {
            hiveFileWriter = new RecordFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.partitionStorageFormat.getEstimatedWriterMemoryUsage(), outputConf, this.typeManager, this.parquetTimeZone, this.session);
        }
        String writerImplementation = hiveFileWriter.getClass().getName();
        Consumer<HiveWriter> onCommit = hiveWriter -> {
            Optional<Object> size;
            try {
                size = Optional.of(hiveWriter.getWrittenBytes());
            }
            catch (RuntimeException e) {
                size = Optional.empty();
            }
            this.eventClient.post((Object[])new WriteCompletedEvent[]{new WriteCompletedEvent(this.session.getQueryId(), path.toString(), this.schemaName, this.tableName, partitionName.orElse(null), outputStorageFormat.getOutputFormat(), writerImplementation, this.nodeManager.getCurrentNode().getVersion(), this.nodeManager.getCurrentNode().getHost(), this.session.getIdentity().getPrincipal().map(Principal::getName).orElse(null), this.nodeManager.getEnvironment(), this.sessionProperties, size.orElse(null), hiveWriter.getRowCount())});
        };
        if (!this.sortedBy.isEmpty()) {
            FileSystem fileSystem;
            Path tempFilePath;
            if (this.sortedWritingTempStagingPathEnabled) {
                String tempPrefix = this.sortedWritingTempStagingPath.replace("${USER}", new HdfsContext(this.session).getIdentity().getUser());
                tempFilePath = new Path(tempPrefix, ".tmp-sort." + path.getParent().getName() + "." + path.getName());
            } else {
                tempFilePath = new Path(path.getParent(), ".tmp-sort." + path.getName());
            }
            try {
                Configuration configuration = new Configuration((Configuration)outputConf);
                configuration.set("fs.defaultFS", "file:///");
                fileSystem = this.hdfsEnvironment.getFileSystem(this.session.getIdentity(), tempFilePath, configuration);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, (Throwable)e);
            }
            List types = (List)this.dataColumns.stream().map(column -> column.getHiveType().getType(this.typeManager, HiveSessionProperties.getTimestampPrecision(this.session))).collect(ImmutableList.toImmutableList());
            HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataColumns.size(); ++i) {
                columnIndexes.put(this.dataColumns.get(i).getName(), i);
            }
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (SortingColumn column2 : this.sortedBy) {
                Integer index = (Integer)columnIndexes.get(column2.getColumnName());
                if (index == null) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Sorting column '%s' does exist in table '%s.%s'", column2.getColumnName(), this.schemaName, this.tableName));
                }
                sortFields.add(index);
                sortOrders.add(column2.getOrder().getSortOrder());
            }
            hiveFileWriter = new SortingFileWriter(fileSystem, tempFilePath, (FileWriter)hiveFileWriter, this.sortBufferSize, this.maxOpenSortFiles, types, sortFields, sortOrders, this.pageSorter, this.typeManager.getTypeOperators(), OrcFileWriterFactory::createOrcDataSink);
        }
        return new HiveWriter((FileWriter)hiveFileWriter, partitionName, updateMode, (String)fileNameWithExtension, writeInfo.getWritePath().toString(), writeInfo.getTargetPath().toString(), onCommit, this.hiveWriterStats);
    }

    public SortingFileWriter makeRowIdSortingWriter(FileWriter deleteFileWriter, Path path) {
        FileSystem fileSystem;
        Path tempFilePath = new Path(path.getParent(), ".tmp-sort." + path.getName());
        try {
            Configuration configuration = new Configuration((Configuration)this.conf);
            configuration.set("fs.defaultFS", "file:///");
            fileSystem = this.hdfsEnvironment.getFileSystem(this.session.getIdentity(), tempFilePath, configuration);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, (Throwable)e);
        }
        ImmutableList sortFields = ImmutableList.of((Object)1, (Object)3);
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST);
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)this.rowType.get());
        return new SortingFileWriter(fileSystem, tempFilePath, deleteFileWriter, this.sortBufferSize, this.maxOpenSortFiles, (List<Type>)types, (List<Integer>)sortFields, (List<SortOrder>)sortOrders, this.pageSorter, this.typeManager.getTypeOperators(), OrcFileWriterFactory::createOrcDataSink);
    }

    private void validateSchema(Optional<String> partitionName, Properties schema) {
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<HiveType> fileColumnHiveTypes = HiveUtil.getColumnTypes(schema);
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet<String>(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' does not have columns %s", this.schemaName, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName.orElse(""), this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType())) continue;
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName.orElse(""), columnName, fileColumnHiveType));
        }
    }

    private String computeAcidSubdir(AcidTransaction transaction) {
        long writeId = transaction.getWriteId();
        switch (transaction.getOperation()) {
            case INSERT: 
            case CREATE_TABLE: {
                return AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)0);
            }
            case DELETE: {
                return AcidUtils.deleteDeltaSubdir((long)writeId, (long)writeId, (int)0);
            }
            case MERGE: {
                return AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)0);
            }
        }
        throw new UnsupportedOperationException("transaction operation is " + transaction.getOperation());
    }

    private String computeFileName(OptionalInt bucketNumber) {
        if (bucketNumber.isPresent()) {
            if (this.isCreateTransactionalTable) {
                return HiveWriterFactory.computeTransactionalBucketedFilename(bucketNumber.getAsInt());
            }
            return HiveWriterFactory.computeNonTransactionalBucketedFilename(this.queryId, bucketNumber.getAsInt());
        }
        if (this.isCreateTransactionalTable) {
            String paddedBucket = Strings.padStart((String)"0", (int)BUCKET_NUMBER_PADDING, (char)'0');
            UUID uuid = UUID.randomUUID();
            return String.format("0%s_%s%s", paddedBucket, Long.toUnsignedString(uuid.getLeastSignificantBits()), Long.toUnsignedString(uuid.getMostSignificantBits()));
        }
        return this.queryId + "_" + UUID.randomUUID();
    }

    public static String computeNonTransactionalBucketedFilename(String queryId, int bucket) {
        return HiveWriterFactory.computeBucketedFileName(Optional.of(UUID.randomUUID() + "_" + queryId), bucket);
    }

    public static String computeTransactionalBucketedFilename(int bucket) {
        return HiveWriterFactory.computeBucketedFileName(Optional.empty(), bucket);
    }

    private static String computeBucketedFileName(Optional<String> suffix, int bucket) {
        String paddedBucket = Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
        if (suffix.isPresent()) {
            return String.format("0%s_0_%s", paddedBucket, suffix.get());
        }
        return String.format("0%s_0", paddedBucket);
    }

    public static int getBucketFromFileName(String fileName) {
        Matcher matcher = BUCKET_FROM_FILENAME_PATTERN.matcher(fileName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"filename %s does not match pattern %s", (Object)fileName, (Object)BUCKET_FROM_FILENAME_PATTERN);
        return Integer.parseInt(matcher.group(1));
    }

    public static String getFileExtension(JobConf conf, StorageFormat storageFormat) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT) || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return "";
        }
        String compressionCodecClass = conf.get("mapred.output.compression.codec");
        if (compressionCodecClass == null) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            Class<CompressionCodec> codecClass = conf.getClassByName(compressionCodecClass).asSubclass(CompressionCodec.class);
            return ((CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)conf)).getDefaultExtension();
        }
        catch (ClassNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec not found: " + compressionCodecClass, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodecClass, (Throwable)e);
        }
    }

    private static class DataColumn {
        private final String name;
        private final HiveType hiveType;

        public DataColumn(String name, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }

    public static interface RowIdSortingFileWriterMaker {
        public SortingFileWriter makeFileWriter(FileWriter var1, Path var2);
    }
}

