/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.RcFileFileWriter;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.rcfile.HdfsRcFileDataSource;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.rcfile.RcFileDataSource;
import io.trino.rcfile.RcFileEncoding;
import io.trino.rcfile.binary.BinaryRcFileEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class RcFileFileWriterFactory
implements HiveFileWriterFactory {
    private final DateTimeZone timeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats stats;

    @Inject
    public RcFileFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, HiveConfig hiveConfig, FileFormatDataSourceStats stats) {
        this(hdfsEnvironment, typeManager, nodeVersion, hiveConfig.getRcfileDateTimeZone(), stats);
    }

    public RcFileFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, DateTimeZone timeZone, FileFormatDataSourceStats stats) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public Optional<FileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session, OptionalInt bucketNumber, AcidTransaction transaction, boolean useAcidSchema, WriterKind writerKind) {
        BinaryRcFileEncoding rcFileEncoding;
        if (!RCFileOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        if (LazyBinaryColumnarSerDe.class.getName().equals(storageFormat.getSerde())) {
            rcFileEncoding = new BinaryRcFileEncoding(this.timeZone);
        } else if (ColumnarSerDe.class.getName().equals(storageFormat.getSerde())) {
            rcFileEncoding = RcFilePageSourceFactory.createTextVectorEncoding(schema);
        } else {
            return Optional.empty();
        }
        Optional<String> codecName = Optional.ofNullable(configuration.get("mapreduce.output.fileoutputformat.compress.codec"));
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<Type> fileColumnTypes = HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(this.typeManager, HiveSessionProperties.getTimestampPrecision(session))).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getIdentity(), path, (Configuration)configuration);
            FSDataOutputStream outputStream = fileSystem.create(path, false);
            Optional<Supplier<RcFileDataSource>> validationInputFactory = Optional.empty();
            if (HiveSessionProperties.isRcfileOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> {
                    try {
                        return new HdfsRcFileDataSource(path.toString(), fileSystem.open(path), fileSystem.getFileStatus(path).getLen(), this.stats);
                    }
                    catch (IOException e) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
                    }
                });
            }
            Callable<Void> rollbackAction = () -> {
                fileSystem.delete(path, false);
                return null;
            };
            return Optional.of(new RcFileFileWriter((OutputStream)outputStream, rollbackAction, (RcFileEncoding)rcFileEncoding, fileColumnTypes, codecName, fileInputColumnIndexes, (Map<String, String>)ImmutableMap.builder().put((Object)"presto_version", (Object)this.nodeVersion.toString()).put((Object)"presto_query_id", (Object)session.getQueryId()).buildOrThrow(), validationInputFactory));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating RCFile file", (Throwable)e);
        }
    }
}

