/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class AwsApiCallStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat totalFailures = new CounterStat();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V, E extends Exception> V call(ThrowingCallable<V, E> callable) throws E {
        try (TimeStat.BlockTimer ignored = this.time.time();){
            V v = callable.call();
            return v;
        }
        catch (Exception e) {
            this.totalFailures.update(1L);
            throw e;
        }
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    public void recordCall(long executionTimeNanos, boolean failure) {
        this.time.addNanos(executionTimeNanos);
        if (failure) {
            this.totalFailures.update(1L);
        }
    }

    public static interface ThrowingCallable<V, E extends Exception>
    extends Callable<V> {
        @Override
        public V call() throws E;
    }
}

