/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.cos;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class ServiceConfig {
    private static final String ACCESS_KEY_SUFFIX = ".access-key";
    private static final String SECRET_KEY_SUFFIX = ".secret-key";
    private static final String ENDPOINT_SUFFIX = ".endpoint";
    private final String name;
    private final String accessKey;
    private final String secretKey;
    private final Optional<String> endpoint;

    public ServiceConfig(String name, String accessKey, String secretKey, Optional<String> endpoint) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.accessKey = Objects.requireNonNull(accessKey, "accessKey is null");
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
    }

    public String getName() {
        return this.name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Optional<String> getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    public static Map<String, ServiceConfig> loadServiceConfigs(File configFile) {
        if (configFile == null) {
            return ImmutableMap.of();
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(configFile));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Set serviceNames = (Set)properties.keySet().stream().map(String.class::cast).map(ServiceConfig::getServiceName).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
        ImmutableMap.Builder configs = ImmutableMap.builder();
        HashSet<String> usedProperties = new HashSet<String>();
        for (String serviceName : serviceNames) {
            String accessKey = ServiceConfig.getRequiredProperty(serviceName + ACCESS_KEY_SUFFIX, properties, configFile, usedProperties);
            String secretKey = ServiceConfig.getRequiredProperty(serviceName + SECRET_KEY_SUFFIX, properties, configFile, usedProperties);
            Optional<String> endpoint = ServiceConfig.getOptionalProperty(serviceName + ENDPOINT_SUFFIX, properties, usedProperties);
            configs.put((Object)serviceName, (Object)new ServiceConfig(serviceName, accessKey, secretKey, endpoint));
        }
        Sets.SetView unusedProperties = Sets.difference(properties.keySet(), usedProperties);
        Preconditions.checkArgument((boolean)unusedProperties.isEmpty(), (String)"Not all properties in file %s were used: %s", (Object)configFile, (Object)unusedProperties);
        return configs.buildOrThrow();
    }

    private static Optional<String> getServiceName(String propertyName) {
        if (propertyName.endsWith(ACCESS_KEY_SUFFIX)) {
            return Optional.of(propertyName.substring(0, propertyName.length() - ACCESS_KEY_SUFFIX.length()));
        }
        if (propertyName.endsWith(SECRET_KEY_SUFFIX)) {
            return Optional.of(propertyName.substring(0, propertyName.length() - SECRET_KEY_SUFFIX.length()));
        }
        if (propertyName.endsWith(ENDPOINT_SUFFIX)) {
            return Optional.of(propertyName.substring(0, propertyName.length() - ENDPOINT_SUFFIX.length()));
        }
        return Optional.empty();
    }

    private static String getRequiredProperty(String propertyName, Properties properties, File configFile, Set<String> usedProperties) {
        String value = properties.getProperty(propertyName);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"%s bucket property not provided in file %s", (Object)propertyName, (Object)configFile);
        usedProperties.add(propertyName);
        return value;
    }

    private static Optional<String> getOptionalProperty(String propertyName, Properties properties, Set<String> usedProperties) {
        String value = properties.getProperty(propertyName);
        if (value != null) {
            usedProperties.add(propertyName);
        }
        return Optional.ofNullable(value);
    }
}

