/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.fs.BlockLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;

public class TrinoFileStatus
implements Comparable<TrinoFileStatus> {
    private final List<BlockLocation> blockLocations;
    private final Path path;
    private final boolean isDirectory;
    private final long length;
    private final long modificationTime;

    public TrinoFileStatus(LocatedFileStatus fileStatus) {
        this(BlockLocation.fromHiveBlockLocations(fileStatus.getBlockLocations()), fileStatus.getPath(), fileStatus.isDirectory(), fileStatus.getLen(), fileStatus.getModificationTime());
    }

    public TrinoFileStatus(List<BlockLocation> blockLocations, Path path, boolean isDirectory, long length, long modificationTime) {
        this.blockLocations = ImmutableList.copyOf((Collection)Objects.requireNonNull(blockLocations, "blockLocations is null"));
        this.path = Objects.requireNonNull(path, "path is null");
        this.isDirectory = isDirectory;
        this.length = length;
        this.modificationTime = modificationTime;
    }

    public List<BlockLocation> getBlockLocations() {
        return this.blockLocations;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getLength() {
        return this.length;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public int compareTo(TrinoFileStatus other) {
        return this.path.compareTo((Object)other.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinoFileStatus that = (TrinoFileStatus)o;
        return this.isDirectory == that.isDirectory && this.length == that.length && this.modificationTime == that.modificationTime && this.blockLocations.equals(that.blockLocations) && this.path.equals((Object)that.path);
    }

    public int hashCode() {
        return Objects.hash(this.blockLocations, this.path, this.isDirectory, this.length, this.modificationTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockLocations", this.blockLocations).add("path", (Object)this.path).add("isDirectory", this.isDirectory).add("length", this.length).add("modificationTime", this.modificationTime).toString();
    }
}

