/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.BatchUpdatePartitionRequest;
import com.amazonaws.services.glue.model.BatchUpdatePartitionRequestEntry;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.PartitionError;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.amazonaws.services.glue.model.Segment;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.aws.AwsApiCallStats;
import io.trino.plugin.hive.aws.AwsCurrentRegionHolder;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueCatalogIdRequestHandler;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.GlueExpressionUtil;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.converter.GlueInputConverter;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class GlueHiveMetastore
implements HiveMetastore {
    private static final Logger log = Logger.get(GlueHiveMetastore.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final int BATCH_GET_PARTITION_MAX_PAGE_SIZE = 1000;
    private static final int BATCH_CREATE_PARTITION_MAX_PAGE_SIZE = 100;
    private static final int BATCH_UPDATE_PARTITION_MAX_PAGE_SIZE = 100;
    private static final int AWS_GLUE_GET_PARTITIONS_MAX_RESULTS = 1000;
    private static final Comparator<Iterable<String>> PARTITION_VALUE_COMPARATOR = Comparators.lexicographical((Comparator)String.CASE_INSENSITIVE_ORDER);
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsContext hdfsContext;
    private final AWSGlueAsync glueClient;
    private final Optional<String> defaultDir;
    private final int partitionSegments;
    private final Executor partitionsReadExecutor;
    private final GlueMetastoreStats stats = new GlueMetastoreStats();
    private final GlueColumnStatisticsProvider columnStatisticsProvider;
    private final boolean assumeCanonicalPartitionKeys;
    private final Predicate<com.amazonaws.services.glue.model.Table> tableFilter;

    @Inject
    public GlueHiveMetastore(HdfsEnvironment hdfsEnvironment, GlueHiveMetastoreConfig glueConfig, AWSCredentialsProvider credentialsProvider, @ForGlueHiveMetastore Executor partitionsReadExecutor, GlueColumnStatisticsProviderFactory columnStatisticsProviderFactory, @ForGlueHiveMetastore Optional<RequestHandler2> requestHandler, @ForGlueHiveMetastore Predicate<com.amazonaws.services.glue.model.Table> tableFilter) {
        Objects.requireNonNull(credentialsProvider, "credentialsProvider is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = new HdfsContext(ConnectorIdentity.ofUser((String)DEFAULT_METASTORE_USER));
        this.glueClient = GlueHiveMetastore.createAsyncGlueClient(glueConfig, credentialsProvider, requestHandler, this.stats.newRequestMetricsCollector());
        this.defaultDir = glueConfig.getDefaultWarehouseDir();
        this.partitionSegments = glueConfig.getPartitionSegments();
        this.partitionsReadExecutor = Objects.requireNonNull(partitionsReadExecutor, "partitionsReadExecutor is null");
        this.assumeCanonicalPartitionKeys = glueConfig.isAssumeCanonicalPartitionKeys();
        this.tableFilter = Objects.requireNonNull(tableFilter, "tableFilter is null");
        this.columnStatisticsProvider = columnStatisticsProviderFactory.createGlueColumnStatisticsProvider(this.glueClient, this.stats);
    }

    public static AWSGlueAsync createAsyncGlueClient(GlueHiveMetastoreConfig config, AWSCredentialsProvider credentialsProvider, Optional<RequestHandler2> requestHandler, RequestMetricCollector metricsCollector) {
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getMaxGlueConnections()).withMaxErrorRetry(config.getMaxGlueErrorRetries());
        AWSGlueAsyncClientBuilder asyncGlueClientBuilder = (AWSGlueAsyncClientBuilder)((AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withMetricsCollector(metricsCollector)).withClientConfiguration(clientConfig);
        ImmutableList.Builder requestHandlers = ImmutableList.builder();
        requestHandler.ifPresent(arg_0 -> ((ImmutableList.Builder)requestHandlers).add(arg_0));
        config.getCatalogId().ifPresent(catalogId -> requestHandlers.add((Object)new GlueCatalogIdRequestHandler((String)catalogId)));
        asyncGlueClientBuilder.setRequestHandlers((RequestHandler2[])requestHandlers.build().toArray(RequestHandler2[]::new));
        if (config.getGlueEndpointUrl().isPresent()) {
            Preconditions.checkArgument((boolean)config.getGlueRegion().isPresent(), (Object)"Glue region must be set when Glue endpoint URL is set");
            asyncGlueClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getGlueEndpointUrl().get(), config.getGlueRegion().get()));
        } else if (config.getGlueRegion().isPresent()) {
            asyncGlueClientBuilder.setRegion(config.getGlueRegion().get());
        } else if (config.getPinGlueClientToCurrentRegion()) {
            asyncGlueClientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEC2Metadata().getName());
        }
        asyncGlueClientBuilder.setCredentials(credentialsProvider);
        return (AWSGlueAsync)asyncGlueClientBuilder.build();
    }

    @Managed
    @Flatten
    public GlueMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            GetDatabaseResult result = this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(new GetDatabaseRequest().withName(databaseName)));
            return Optional.of(GlueToTrinoConverter.convertDatabase(result.getDatabase()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            List databaseNames = (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getDatabases(arg_0), new GetDatabasesRequest(), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, this.stats.getGetDatabases()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).map(com.amazonaws.services.glue.model.Database::getName).collect(ImmutableList.toImmutableList());
            return databaseNames;
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            GetTableResult result = this.stats.getGetTable().call(() -> this.glueClient.getTable(new GetTableRequest().withDatabaseName(databaseName).withName(tableName)));
            return Optional.of(GlueToTrinoConverter.convertTable(result.getTable(), databaseName));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.columnStatisticsProvider.getSupportedColumnStatistics(type);
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public PartitionStatistics getTableStatistics(Table table) {
        return new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters()), this.columnStatisticsProvider.getTableColumnStatistics(table));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        return (Map)this.columnStatisticsProvider.getPartitionColumnStatistics(partitions).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> MetastoreUtil.makePartitionName(table, (Partition)entry.getKey()), entry -> new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(((Partition)entry.getKey()).getParameters()), (Map)entry.getValue())));
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        Table table = this.getExistingTable(databaseName, tableName);
        if (transaction.isAcidTransactionRunning()) {
            table = Table.builder(table).setWriteId(OptionalLong.of(transaction.getWriteId())).build();
        }
        PartitionStatistics currentStatistics = this.getTableStatistics(table);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        try {
            TableInput tableInput = GlueInputConverter.convertTable(table);
            Map<String, String> statisticsParameters = ThriftMetastoreUtil.updateStatisticsParameters(table.getParameters(), updatedStatistics.getBasicStatistics());
            tableInput.setParameters(statisticsParameters);
            table = Table.builder(table).setParameters(statisticsParameters).build();
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(tableInput)));
            this.columnStatisticsProvider.updateTableColumnStatistics(table, updatedStatistics.getColumnStatistics());
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updatePartitionStatistics(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        Iterables.partition(updates.entrySet(), (int)100).forEach(partitionUpdates -> this.updatePartitionStatisticsBatch(table, (Map)partitionUpdates.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    private void updatePartitionStatisticsBatch(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        ImmutableList.Builder partitionUpdateRequests = ImmutableList.builder();
        ImmutableSet.Builder columnStatisticsUpdates = ImmutableSet.builder();
        Map partitionValuesToName = (Map)updates.keySet().stream().collect(ImmutableMap.toImmutableMap(HiveUtil::toPartitionValues, UnaryOperator.identity()));
        List<Partition> partitions = this.batchGetPartition(table, (List<String>)ImmutableList.copyOf(updates.keySet()));
        Map<Partition, Map<String, HiveColumnStatistics>> statisticsPerPartition = this.columnStatisticsProvider.getPartitionColumnStatistics(partitions);
        statisticsPerPartition.forEach((partition, columnStatistics) -> {
            Function update = (Function)updates.get(partitionValuesToName.get(partition.getValues()));
            PartitionStatistics currentStatistics = new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters()), (Map<String, HiveColumnStatistics>)columnStatistics);
            PartitionStatistics updatedStatistics = (PartitionStatistics)update.apply(currentStatistics);
            Map<String, String> updatedStatisticsParameters = ThriftMetastoreUtil.updateStatisticsParameters(partition.getParameters(), updatedStatistics.getBasicStatistics());
            partition = Partition.builder(partition).setParameters(updatedStatisticsParameters).build();
            Map<String, HiveColumnStatistics> updatedColumnStatistics = updatedStatistics.getColumnStatistics();
            PartitionInput partitionInput = GlueInputConverter.convertPartition(partition);
            partitionInput.setParameters(partition.getParameters());
            partitionUpdateRequests.add((Object)new BatchUpdatePartitionRequestEntry().withPartitionValueList(partition.getValues()).withPartitionInput(partitionInput));
            columnStatisticsUpdates.add((Object)new GlueColumnStatisticsProvider.PartitionStatisticsUpdate((Partition)partition, updatedColumnStatistics));
        });
        List partitionUpdateRequestsPartitioned = Lists.partition((List)partitionUpdateRequests.build(), (int)100);
        ArrayList partitionUpdateRequestsFutures = new ArrayList();
        partitionUpdateRequestsPartitioned.forEach(partitionUpdateRequestsPartition -> partitionUpdateRequestsFutures.add(this.glueClient.batchUpdatePartitionAsync(new BatchUpdatePartitionRequest().withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withEntries((Collection)partitionUpdateRequestsPartition), new StatsRecordingAsyncHandler(this.stats.getBatchUpdatePartition()))));
        try {
            this.columnStatisticsProvider.updatePartitionStatistics((Set<GlueColumnStatisticsProvider.PartitionStatisticsUpdate>)columnStatisticsUpdates.build());
            partitionUpdateRequestsFutures.forEach(MoreFutures::getFutureValue);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            List tableNames = (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), new GetTablesRequest().withDatabaseName(databaseName), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).filter(this.tableFilter).map(com.amazonaws.services.glue.model.Table::getName).collect(ImmutableList.toImmutableList());
            return tableNames;
        }
        catch (EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public synchronized List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        throw new UnsupportedOperationException("getTablesWithParameter for GlueHiveMetastore is not implemented");
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        try {
            List views = (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), new GetTablesRequest().withDatabaseName(databaseName), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).filter(table -> TableType.VIRTUAL_VIEW.name().equals(table.getTableType())).map(com.amazonaws.services.glue.model.Table::getName).collect(ImmutableList.toImmutableList());
            return views;
        }
        catch (EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createDatabase(Database database) {
        if (database.getLocation().isEmpty() && this.defaultDir.isPresent()) {
            String databaseLocation = new Path(this.defaultDir.get(), database.getDatabaseName()).toString();
            database = Database.builder(database).setLocation(Optional.of(databaseLocation)).build();
        }
        try {
            DatabaseInput databaseInput = GlueInputConverter.convertDatabase(database);
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(new CreateDatabaseRequest().withDatabaseInput(databaseInput)));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (database.getLocation().isPresent()) {
            HiveWriteUtils.createDirectory(this.hdfsContext, this.hdfsEnvironment, new Path(database.getLocation().get()));
        }
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        Optional<Object> location = Optional.empty();
        if (deleteData) {
            location = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName)).getLocation();
        }
        try {
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(databaseName)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (deleteData) {
            location.ifPresent(path -> GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(path), true));
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            Database database = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
            DatabaseInput renamedDatabase = GlueInputConverter.convertDatabase(database).withName(newDatabaseName);
            this.stats.getUpdateDatabase().call(() -> this.glueClient.updateDatabase(new UpdateDatabaseRequest().withName(databaseName).withDatabaseInput(renamedDatabase)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setting the database owner is not supported by Glue");
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput input = GlueInputConverter.convertTable(table);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(table.getDatabaseName()).withTableInput(input)));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDatabaseName(), table.getTableName()));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(table.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        Table table = this.getExistingTable(databaseName, tableName);
        try {
            this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(databaseName).withName(tableName)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        Optional<String> location = table.getStorage().getOptionalLocation().filter(Predicate.not(String::isEmpty));
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && location.isPresent()) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(location.get()), true);
        }
    }

    private static boolean isManagedTable(Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    private static void deleteDir(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path, boolean recursive) {
        try {
            hdfsEnvironment.getFileSystem(context, path).delete(path, recursive);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete path: %s", new Object[]{path});
        }
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        if (!tableName.equals(newTable.getTableName()) || !databaseName.equals(newTable.getDatabaseName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not yet supported by Glue service");
        }
        try {
            TableInput newTableInput = GlueInputConverter.convertTable(newTable);
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(newTableInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        boolean newTableCreated = false;
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(databaseName).withName(tableName);
            GetTableResult glueTable = this.glueClient.getTable(getTableRequest);
            TableInput tableInput = this.convertGlueTableToTableInput(glueTable.getTable(), newTableName);
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(newDatabaseName).withTableInput(tableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.dropTable(databaseName, tableName, false);
        }
        catch (RuntimeException e) {
            block5: {
                if (newTableCreated) {
                    try {
                        this.dropTable(databaseName, tableName, false);
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block5;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    private TableInput convertGlueTableToTableInput(com.amazonaws.services.glue.model.Table glueTable, String newTableName) {
        return new TableInput().withName(newTableName).withDescription(glueTable.getDescription()).withOwner(glueTable.getOwner()).withLastAccessTime(glueTable.getLastAccessTime()).withLastAnalyzedTime(glueTable.getLastAnalyzedTime()).withRetention(glueTable.getRetention()).withStorageDescriptor(glueTable.getStorageDescriptor()).withPartitionKeys((Collection)glueTable.getPartitionKeys()).withViewOriginalText(glueTable.getViewOriginalText()).withViewExpandedText(glueTable.getViewExpandedText()).withTableType(glueTable.getTableType()).withTargetTable(glueTable.getTargetTable()).withParameters(glueTable.getParameters());
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table comment is not yet supported by Glue service");
    }

    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        try {
            Table table = this.getExistingTable(databaseName, tableName);
            TableInput newTableInput = GlueInputConverter.convertTable(table);
            newTableInput.setOwner(principal.getName());
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(newTableInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Column comment is not yet supported by Glue service");
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Table oldTable = this.getExistingTable(databaseName, tableName);
        Table newTable = Table.builder(oldTable).addDataColumn(new Column(columnName, columnType, Optional.ofNullable(columnComment))).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Table oldTable = this.getExistingTable(databaseName, tableName);
        if (oldTable.getPartitionColumns().stream().anyMatch(c -> c.getName().equals(oldColumnName))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column column : oldTable.getDataColumns()) {
            if (column.getName().equals(oldColumnName)) {
                newDataColumns.add((Object)new Column(newColumnName, column.getType(), column.getComment()));
                continue;
            }
            newDataColumns.add((Object)column);
        }
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        Table oldTable = this.getExistingTable(databaseName, tableName);
        if (oldTable.getColumn(columnName).isEmpty()) {
            SchemaTableName name = new SchemaTableName(databaseName, tableName);
            throw new ColumnNotFoundException(name, columnName);
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        oldTable.getDataColumns().stream().filter(fieldSchema -> !fieldSchema.getName().equals(columnName)).forEach(arg_0 -> ((ImmutableList.Builder)newDataColumns).add(arg_0));
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        try {
            GetPartitionResult result = this.stats.getGetPartition().call(() -> this.glueClient.getPartition(new GetPartitionRequest().withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionValues((Collection)partitionValues)));
            return Optional.of(new GlueToTrinoConverter.GluePartitionConverter(table).apply(result.getPartition()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        if (partitionKeysFilter.isNone()) {
            return Optional.of(ImmutableList.of());
        }
        String expression = GlueExpressionUtil.buildGlueExpression(columnNames, partitionKeysFilter, this.assumeCanonicalPartitionKeys);
        List<List<String>> partitionValues = this.getPartitionValues(databaseName, tableName, expression);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(columnNames, partitionValues));
    }

    private List<List<String>> getPartitionValues(String databaseName, String tableName, String expression) {
        if (this.partitionSegments == 1) {
            return this.getPartitionValues(databaseName, tableName, expression, null);
        }
        ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(this.partitionsReadExecutor);
        for (int i = 0; i < this.partitionSegments; ++i) {
            Segment segment = new Segment().withSegmentNumber(Integer.valueOf(i)).withTotalSegments(Integer.valueOf(this.partitionSegments));
            completionService.submit(() -> this.getPartitionValues(databaseName, tableName, expression, segment));
        }
        ArrayList<List<String>> partitions = new ArrayList<List<String>>();
        try {
            for (int i = 0; i < this.partitionSegments; ++i) {
                Future futurePartitions = completionService.take();
                partitions.addAll((Collection)futurePartitions.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to fetch partitions from Glue Data Catalog", (Throwable)e);
        }
        partitions.sort(PARTITION_VALUE_COMPARATOR);
        return partitions;
    }

    private List<List<String>> getPartitionValues(String databaseName, String tableName, String expression, @Nullable Segment segment) {
        try {
            return (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getPartitions(arg_0), new GetPartitionsRequest().withDatabaseName(databaseName).withTableName(tableName).withExpression(expression).withSegment(segment).withExcludeColumnSchema(Boolean.valueOf(true)).withMaxResults(Integer.valueOf(1000)), GetPartitionsRequest::setNextToken, GetPartitionsResult::getNextToken, this.stats.getGetPartitions()).map(GetPartitionsResult::getPartitions).flatMap(Collection::stream).map(com.amazonaws.services.glue.model.Partition::getValues).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private static List<String> buildPartitionNames(List<String> partitionColumns, List<List<String>> partitions) {
        return GlueToTrinoConverter.mappedCopy(partitions, partition -> MetastoreUtil.toPartitionName(partitionColumns, partition));
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        return this.stats.getGetPartitionByName().call(() -> this.getPartitionsByNamesInternal(table, partitionNames));
    }

    private Map<String, Optional<Partition>> getPartitionsByNamesInternal(Table table, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        List<Partition> partitions = this.batchGetPartition(table, partitionNames);
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = partitions.stream().collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put((Object)((String)entry.getKey()), Optional.ofNullable(partition));
        }
        return resultBuilder.buildOrThrow();
    }

    private List<Partition> batchGetPartition(Table table, List<String> partitionNames) {
        try {
            List pendingPartitions = partitionNames.stream().map(partitionName -> new PartitionValueList().withValues(HiveUtil.toPartitionValues(partitionName))).collect(Collectors.toCollection(ArrayList::new));
            ImmutableList.Builder resultsBuilder = ImmutableList.builderWithExpectedSize((int)partitionNames.size());
            GlueToTrinoConverter.GluePartitionConverter converter = new GlueToTrinoConverter.GluePartitionConverter(table);
            while (!pendingPartitions.isEmpty()) {
                ArrayList<Future> batchGetPartitionFutures = new ArrayList<Future>();
                for (List partitions : Lists.partition((List)pendingPartitions, (int)1000)) {
                    batchGetPartitionFutures.add(this.glueClient.batchGetPartitionAsync(new BatchGetPartitionRequest().withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionsToGet((Collection)partitions), new StatsRecordingAsyncHandler(this.stats.getGetPartitions())));
                }
                pendingPartitions.clear();
                for (Future future : batchGetPartitionFutures) {
                    BatchGetPartitionResult batchGetPartitionResult = (BatchGetPartitionResult)future.get();
                    List partitions = batchGetPartitionResult.getPartitions();
                    List unprocessedKeys = batchGetPartitionResult.getUnprocessedKeys();
                    if (partitions.isEmpty()) {
                        Verify.verify((!unprocessedKeys.isEmpty() ? 1 : 0) != 0, (String)"Empty unprocessedKeys for non-empty BatchGetPartitionRequest and empty partitions result", (Object[])new Object[0]);
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Cannot make progress retrieving partitions. Unable to retrieve partitions: " + unprocessedKeys);
                    }
                    partitions.stream().map(converter).forEach(arg_0 -> ((ImmutableList.Builder)resultsBuilder).add(arg_0));
                    pendingPartitions.addAll(unprocessedKeys);
                }
            }
            return resultsBuilder.build();
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.stats.getCreatePartitions().call(() -> {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (List partitionBatch : Lists.partition((List)partitions, (int)100)) {
                    List<PartitionInput> partitionInputs = GlueToTrinoConverter.mappedCopy(partitionBatch, GlueInputConverter::convertPartition);
                    futures.add(this.glueClient.batchCreatePartitionAsync(new BatchCreatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInputList(partitionInputs), new StatsRecordingAsyncHandler(this.stats.getBatchCreatePartition())));
                }
                for (Future future : futures) {
                    try {
                        BatchCreatePartitionResult result = (BatchCreatePartitionResult)future.get();
                        GlueHiveMetastore.propagatePartitionErrorToTrinoException(databaseName, tableName, result.getErrors());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
                    }
                }
                Set updates = (Set)partitions.stream().map(partitionWithStatistics -> new GlueColumnStatisticsProvider.PartitionStatisticsUpdate(partitionWithStatistics.getPartition(), partitionWithStatistics.getStatistics().getColumnStatistics())).collect(ImmutableSet.toImmutableSet());
                this.columnStatisticsProvider.updatePartitionStatistics(updates);
                return null;
            });
        }
        catch (AmazonServiceException | ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    private static void propagatePartitionErrorToTrinoException(String databaseName, String tableName, List<PartitionError> partitionErrors) {
        if (partitionErrors != null && !partitionErrors.isEmpty()) {
            String glueExceptionCode;
            ErrorDetail errorDetail = partitionErrors.get(0).getErrorDetail();
            switch (glueExceptionCode = errorDetail.getErrorCode()) {
                case "AlreadyExistsException": {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, errorDetail.getErrorMessage());
                }
                case "EntityNotFoundException": {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), errorDetail.getErrorMessage());
                }
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, errorDetail.getErrorCode() + ": " + errorDetail.getErrorMessage());
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        Table table = this.getExistingTable(databaseName, tableName);
        Partition partition = this.getPartition(table, parts).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts));
        try {
            this.stats.getDeletePartition().call(() -> this.glueClient.deletePartition(new DeletePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionValues((Collection)parts)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String partLocation = partition.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)partLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(partLocation), true);
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            PartitionInput newPartition = GlueInputConverter.convertPartition(partition);
            this.stats.getUpdatePartition().call(() -> this.glueClient.updatePartition(new UpdatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInput(newPartition).withPartitionValueList(partition.getPartition().getValues())));
            this.columnStatisticsProvider.updatePartitionStatistics(partition.getPartition(), partition.getStatistics().getColumnStatistics());
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getPartition().getValues());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createRole is not supported by Glue");
    }

    @Override
    public void dropRole(String role) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropRole is not supported by Glue");
    }

    @Override
    public Set<String> listRoles() {
        return ImmutableSet.of((Object)PUBLIC_ROLE_NAME);
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantRoles is not supported by Glue");
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeRoles is not supported by Glue");
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listPrincipals is not supported by Glue");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        if (principal.getType() == PrincipalType.USER) {
            return ImmutableSet.of((Object)new RoleGrant(principal.toTrinoPrincipal(), PUBLIC_ROLE_NAME, false));
        }
        return ImmutableSet.of();
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges is not supported by Glue");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges is not supported by Glue");
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return ImmutableSet.of();
    }

    static class StatsRecordingAsyncHandler<Request extends AmazonWebServiceRequest, Result>
    implements AsyncHandler<Request, Result> {
        private final AwsApiCallStats stats;
        private final Stopwatch stopwatch;

        public StatsRecordingAsyncHandler(AwsApiCallStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
            this.stopwatch = Stopwatch.createStarted();
        }

        public void onError(Exception e) {
            this.stats.recordCall(this.stopwatch.elapsed(TimeUnit.NANOSECONDS), true);
        }

        public void onSuccess(AmazonWebServiceRequest request, Object o) {
            this.stats.recordCall(this.stopwatch.elapsed(TimeUnit.NANOSECONDS), false);
        }
    }
}

