/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.CoalescingCounter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MetastoreSupportsDateStatistics {
    private static final int MAX_SET_DATE_STATISTICS_ATTEMPTS = 100;
    private final AtomicReference<DateStatisticsSupport> supported = new AtomicReference<DateStatisticsSupport>(DateStatisticsSupport.UNKNOWN);
    private final CoalescingCounter failures = new CoalescingCounter(new Duration(1.0, TimeUnit.SECONDS));

    public DateStatisticsSupport isSupported() {
        return this.supported.get();
    }

    public void succeeded() {
        this.supported.set(DateStatisticsSupport.SUPPORTED);
    }

    public void failed() {
        if (this.failures.incrementAndGet() >= 100L) {
            this.supported.set(DateStatisticsSupport.NOT_SUPPORTED);
        }
    }

    public static enum DateStatisticsSupport {
        SUPPORTED,
        NOT_SUPPORTED,
        UNKNOWN;

    }
}

