/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.trino.hdfs.HdfsEnvironment;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class OriginalFilesUtils {
    private OriginalFilesUtils() {
    }

    public static long getPrecedingRowCount(Collection<AcidInfo.OriginalFileInfo> originalFileInfos, Path splitPath, HdfsEnvironment hdfsEnvironment, ConnectorIdentity identity, OrcReaderOptions options, Configuration configuration, FileFormatDataSourceStats stats) {
        long rowCount = 0L;
        for (AcidInfo.OriginalFileInfo originalFileInfo : originalFileInfos) {
            Path path = new Path(splitPath.getParent() + "/" + originalFileInfo.getName());
            if (path.compareTo((Object)splitPath) >= 0) continue;
            rowCount += OriginalFilesUtils.getRowsInFile(path, hdfsEnvironment, identity, options, configuration, stats, originalFileInfo.getFileSize()).longValue();
        }
        return rowCount;
    }

    private static Long getRowsInFile(Path splitPath, HdfsEnvironment hdfsEnvironment, ConnectorIdentity identity, OrcReaderOptions options, Configuration configuration, FileFormatDataSourceStats stats, long fileSize) {
        Long l;
        FileSystem fileSystem = hdfsEnvironment.getFileSystem(identity, splitPath, configuration);
        FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(identity, () -> fileSystem.open(splitPath));
        HdfsOrcDataSource orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(splitPath.toString()), fileSize, options, inputStream, stats);
        try {
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Could not read ORC footer from empty file: " + splitPath));
            l = reader.getFooter().getNumberOfRows();
        }
        catch (Throwable throwable) {
            try {
                try {
                    orcDataSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Could not read ORC footer from file: " + splitPath, (Throwable)e);
            }
        }
        orcDataSource.close();
        return l;
    }
}

