/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.slice.Slice;
import io.trino.hdfs.FSDataInputStreamTail;
import io.trino.parquet.AbstractParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;

public class HdfsParquetDataSource
extends AbstractParquetDataSource {
    private final FSDataInputStream inputStream;
    private final FileFormatDataSourceStats stats;

    public HdfsParquetDataSource(ParquetDataSourceId id, long estimatedSize, FSDataInputStream inputStream, FileFormatDataSourceStats stats, ParquetReaderOptions options) {
        super(id, estimatedSize, options);
        this.inputStream = inputStream;
        this.stats = stats;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    protected Slice readTailInternal(int length) {
        try {
            long readStart = System.nanoTime();
            FSDataInputStreamTail fileTail = FSDataInputStreamTail.readTail((String)this.getId().toString(), (long)this.getEstimatedSize(), (FSDataInputStream)this.inputStream, (int)length);
            Slice tailSlice = fileTail.getTailSlice();
            this.stats.readDataBytesPerSecond(tailSlice.length(), System.nanoTime() - readStart);
            return tailSlice;
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error reading tail from %s with length %s", this.getId(), length), (Throwable)e);
        }
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            long readStart = System.nanoTime();
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - readStart);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error reading from %s at position %s", this.getId(), position), (Throwable)e);
        }
    }
}

