/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaInternalFieldManager;
import io.trino.plugin.kafka.KafkaTableHandle;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.plugin.kafka.KafkaTopicFieldDescription;
import io.trino.plugin.kafka.KafkaTopicFieldGroup;
import io.trino.plugin.kafka.schema.TableDescriptionSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ComputedStatistics;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class KafkaMetadata
implements ConnectorMetadata {
    private final boolean hideInternalColumns;
    private final TableDescriptionSupplier tableDescriptionSupplier;
    private final KafkaInternalFieldManager kafkaInternalFieldManager;

    @Inject
    public KafkaMetadata(KafkaConfig kafkaConfig, TableDescriptionSupplier tableDescriptionSupplier, KafkaInternalFieldManager kafkaInternalFieldManager) {
        this.hideInternalColumns = kafkaConfig.isHideInternalColumns();
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
        this.kafkaInternalFieldManager = Objects.requireNonNull(kafkaInternalFieldManager, "kafkaInternalFieldManager is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tableDescriptionSupplier.listTables().stream().map(SchemaTableName::getSchemaName).collect(ImmutableList.toImmutableList());
    }

    public KafkaTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.getTopicDescription(session, schemaTableName).map(kafkaTopicDescription -> new KafkaTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), kafkaTopicDescription.getTopicName(), KafkaMetadata.getDataFormat(kafkaTopicDescription.getKey()), KafkaMetadata.getDataFormat(kafkaTopicDescription.getMessage()), kafkaTopicDescription.getKey().flatMap(KafkaTopicFieldGroup::getDataSchema), kafkaTopicDescription.getMessage().flatMap(KafkaTopicFieldGroup::getDataSchema), kafkaTopicDescription.getKey().flatMap(KafkaTopicFieldGroup::getSubject), kafkaTopicDescription.getMessage().flatMap(KafkaTopicFieldGroup::getSubject), (List)this.getColumnHandles(session, schemaTableName).values().stream().map(KafkaColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), (TupleDomain<ColumnHandle>)TupleDomain.all())).orElse(null);
    }

    private static String getDataFormat(Optional<KafkaTopicFieldGroup> fieldGroup) {
        return fieldGroup.map(KafkaTopicFieldGroup::getDataFormat).orElse("dummy");
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(session, ((KafkaTableHandle)tableHandle).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.tableDescriptionSupplier.listTables().stream().filter(tableName -> schemaName.map(tableName.getSchemaName()::equals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getColumnHandles(session, ((KafkaTableHandle)tableHandle).toSchemaTableName());
    }

    private Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, SchemaTableName schemaTableName) {
        KafkaTopicDescription kafkaTopicDescription = this.getRequiredTopicDescription(session, schemaTableName);
        Stream<KafkaColumnHandle> keyColumnHandles = kafkaTopicDescription.getKey().stream().map(KafkaTopicFieldGroup::getFields).flatMap(Collection::stream).map(kafkaTopicFieldDescription -> kafkaTopicFieldDescription.getColumnHandle(true));
        Stream<KafkaColumnHandle> messageColumnHandles = kafkaTopicDescription.getMessage().stream().map(KafkaTopicFieldGroup::getFields).flatMap(Collection::stream).map(kafkaTopicFieldDescription -> kafkaTopicFieldDescription.getColumnHandle(false));
        List topicColumnHandles = (List)Stream.concat(keyColumnHandles, messageColumnHandles).collect(ImmutableList.toImmutableList());
        List internalColumnHandles = (List)this.kafkaInternalFieldManager.getInternalFields().stream().map(kafkaInternalField -> kafkaInternalField.getColumnHandle(this.hideInternalColumns)).collect(ImmutableList.toImmutableList());
        Set conflictingColumns = topicColumnHandles.stream().map(KafkaColumnHandle::getName).collect(Collectors.toSet());
        conflictingColumns.retainAll(internalColumnHandles.stream().map(KafkaColumnHandle::getName).collect(Collectors.toSet()));
        if (!conflictingColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, "Internal Kafka column names conflict with column names from the table. Consider changing kafka.internal-column-prefix configuration property. topic=" + schemaTableName + ", Conflicting names=" + conflictingColumns);
        }
        return (Map)Stream.concat(topicColumnHandles.stream(), internalColumnHandles.stream()).collect(ImmutableMap.toImmutableMap(KafkaColumnHandle::getName, Function.identity()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        Object tableNames = prefix.getTable().isEmpty() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        for (SchemaTableName tableName : tableNames) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((KafkaColumnHandle)columnHandle).getColumnMetadata();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName schemaTableName) {
        KafkaTopicDescription table = this.getRequiredTopicDescription(session, schemaTableName);
        ImmutableList.Builder builder = ImmutableList.builder();
        table.getKey().ifPresent(key -> {
            List<KafkaTopicFieldDescription> fields = key.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription fieldDescription : fields) {
                    builder.add((Object)fieldDescription.getColumnMetadata());
                }
            }
        });
        table.getMessage().ifPresent(message -> {
            List<KafkaTopicFieldDescription> fields = message.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription fieldDescription : fields) {
                    builder.add((Object)fieldDescription.getColumnMetadata());
                }
            }
        });
        for (KafkaInternalFieldManager.InternalField fieldDescription : this.kafkaInternalFieldManager.getInternalFields()) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        KafkaTableHandle handle = (KafkaTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary())))) {
            return Optional.empty();
        }
        handle = new KafkaTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getTopicName(), handle.getKeyDataFormat(), handle.getMessageDataFormat(), handle.getKeyDataSchemaLocation(), handle.getMessageDataSchemaLocation(), handle.getKeySubject(), handle.getMessageSubject(), handle.getColumns(), (TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary(), false));
    }

    private KafkaTopicDescription getRequiredTopicDescription(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.getTopicDescription(session, schemaTableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
    }

    private Optional<KafkaTopicDescription> getTopicDescription(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.tableDescriptionSupplier.getTopicDescription(session, schemaTableName);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        KafkaTableHandle table = (KafkaTableHandle)tableHandle;
        List actualColumns = (List)table.getColumns().stream().filter(columnHandle -> !columnHandle.isInternal() && !columnHandle.isHidden()).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)columns.equals(actualColumns), (String)"Unexpected columns!\nexpected: %s\ngot: %s", (Object)actualColumns, columns);
        return new KafkaTableHandle(table.getSchemaName(), table.getTableName(), table.getTopicName(), table.getKeyDataFormat(), table.getMessageDataFormat(), table.getKeyDataSchemaLocation(), table.getMessageDataSchemaLocation(), table.getKeySubject(), table.getMessageSubject(), actualColumns, (TupleDomain<ColumnHandle>)TupleDomain.none());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }
}

