/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.plugin.kafka.KafkaClientsModule;
import io.trino.plugin.kafka.KafkaConnectorFactory;
import io.trino.plugin.kafka.security.KafkaSecurityModule;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Objects;

public class KafkaPlugin
implements Plugin {
    public static final Module DEFAULT_EXTENSION = new AbstractConfigurationAwareModule(){

        protected void setup(Binder binder) {
            this.install((Module)new KafkaClientsModule());
            this.install((Module)new KafkaSecurityModule());
        }
    };
    private final Module extension;

    public KafkaPlugin() {
        this(DEFAULT_EXTENSION);
    }

    public KafkaPlugin(Module extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
    }

    public synchronized Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new KafkaConnectorFactory(this.extension));
    }
}

