/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json.format;

import io.trino.plugin.kafka.encoder.json.format.CustomDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.ISO8601DateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.MillisecondsSinceEpochFormatter;
import io.trino.plugin.kafka.encoder.json.format.RFC2822DateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.SecondsSinceEpochFormatter;
import io.trino.spi.type.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public enum DateTimeFormat {
    CUSTOM_DATE_TIME(CustomDateTimeFormatter::new, CustomDateTimeFormatter::isSupportedType),
    ISO8601(pattern -> new ISO8601DateTimeFormatter(), ISO8601DateTimeFormatter::isSupportedType),
    RFC2822(pattern -> new RFC2822DateTimeFormatter(), RFC2822DateTimeFormatter::isSupportedType),
    MILLISECONDS_SINCE_EPOCH(pattern -> new MillisecondsSinceEpochFormatter(), MillisecondsSinceEpochFormatter::isSupportedType),
    SECONDS_SINCE_EPOCH(pattern -> new SecondsSinceEpochFormatter(), SecondsSinceEpochFormatter::isSupportedType);

    private final Function<Optional<String>, JsonDateTimeFormatter> formatterConstructor;
    private final Function<Type, Boolean> isSupportedType;

    private DateTimeFormat(Function<Optional<String>, JsonDateTimeFormatter> formatterConstructor, Function<Type, Boolean> isSupportedType) {
        this.formatterConstructor = Objects.requireNonNull(formatterConstructor, "formatterConstructor is null");
        this.isSupportedType = Objects.requireNonNull(isSupportedType, "isSupportedType is null");
    }

    public boolean isSupportedType(Type type) {
        return this.isSupportedType.apply(type);
    }

    public JsonDateTimeFormatter getFormatter(Optional<String> pattern) {
        return this.formatterConstructor.apply(pattern);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH).replaceAll("_", "-");
    }
}

