/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json.format.util;

import com.google.common.base.Preconditions;

public final class TimeConversions {
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final int MICROSECONDS_PER_MILLISECOND = 1000;
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final int NANOSECONDS_PER_MICROSECOND = 1000;
    public static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    public static final long PICOSECONDS_PER_SECOND = 1000000000000L;
    public static final int PICOSECONDS_PRECISION = 12;
    public static final int NANOSECONDS_PRECISION = 9;
    public static final int MILLISECONDS_PRECISION = 3;
    public static final int SECONDS_PRECISION = 0;
    private static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};

    private TimeConversions() {
    }

    private static long roundDiv(long value, long factor) {
        Preconditions.checkArgument((factor > 0L ? 1 : 0) != 0, (Object)"factor must be positive");
        if (factor == 1L) {
            return value;
        }
        if (value >= 0L) {
            return (value + factor / 2L) / factor;
        }
        return (value + 1L - factor / 2L) / factor;
    }

    public static long round(long value, int magnitude) {
        return TimeConversions.roundToNearest(value, POWERS_OF_TEN[magnitude]);
    }

    public static long roundToNearest(long value, long bound) {
        return TimeConversions.roundDiv(value, bound) * bound;
    }

    public static long scaleFactor(int fromPrecision, int toPrecision) {
        if (fromPrecision > toPrecision) {
            throw new IllegalArgumentException("fromPrecision must be <= toPrecision");
        }
        return POWERS_OF_TEN[toPrecision - fromPrecision];
    }

    public static long rescale(long value, int fromPrecision, int toPrecision) {
        value = fromPrecision <= toPrecision ? (value *= TimeConversions.scaleFactor(fromPrecision, toPrecision)) : (value /= TimeConversions.scaleFactor(toPrecision, fromPrecision));
        return value;
    }

    public static long rescaleWithRounding(long value, int fromPrecision, int toPrecision) {
        value = TimeConversions.round(value, fromPrecision - toPrecision);
        value = TimeConversions.rescale(value, fromPrecision, toPrecision);
        return value;
    }

    public static long scaleEpochMicrosToMillis(long value) {
        return Math.floorDiv(value, 1000);
    }

    public static long scaleEpochMicrosToSeconds(long epochMicros) {
        return Math.floorDiv(epochMicros, 1000000);
    }

    public static long scaleEpochMillisToSeconds(long epochMillis) {
        return Math.floorDiv(epochMillis, 1000);
    }

    public static int getMicrosOfSecond(long epochMicros) {
        return Math.floorMod(epochMicros, 1000000);
    }

    public static int getMillisOfSecond(long epochMillis) {
        return Math.floorMod(epochMillis, 1000);
    }

    public static long scalePicosToNanos(long picos) {
        return TimeConversions.rescaleWithRounding(picos, 12, 9);
    }

    public static long scaleNanosToMillis(long nanos) {
        return TimeConversions.rescaleWithRounding(nanos, 9, 3);
    }

    public static long scalePicosToMillis(long picos) {
        return TimeConversions.rescaleWithRounding(picos, 12, 3);
    }

    public static long scalePicosToSeconds(long picos) {
        return TimeConversions.rescaleWithRounding(picos, 12, 0);
    }

    public static long getNanosOfDay(long epochNanos) {
        return Math.floorMod(epochNanos, 86400000000000L);
    }

    public static long getMillisOfDay(long epochMillis) {
        return Math.floorMod(epochMillis, 86400000L);
    }
}

