/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import com.google.common.cache.LoadingCache;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.core.data.manager.offline.DimensionTableDataManager;
import org.apache.pinot.core.data.manager.offline.OfflineTableDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManagerConfig;
import org.apache.pinot.segment.local.data.manager.TableDataManagerParams;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableType;

public class TableDataManagerProvider {
    private static Semaphore _segmentBuildSemaphore;
    private static TableDataManagerParams _tableDataManagerParams;

    private TableDataManagerProvider() {
    }

    public static void init(InstanceDataManagerConfig instanceDataManagerConfig) {
        int maxParallelBuilds = instanceDataManagerConfig.getMaxParallelSegmentBuilds();
        if (maxParallelBuilds > 0) {
            _segmentBuildSemaphore = new Semaphore(maxParallelBuilds, true);
        }
        _tableDataManagerParams = new TableDataManagerParams(instanceDataManagerConfig);
    }

    public static TableDataManager getTableDataManager(TableDataManagerConfig tableDataManagerConfig, String instanceId, ZkHelixPropertyStore<ZNRecord> propertyStore, ServerMetrics serverMetrics, HelixManager helixManager, LoadingCache<Pair<String, String>, SegmentErrorInfo> errorCache) {
        BaseTableDataManager tableDataManager;
        switch (TableType.valueOf((String)tableDataManagerConfig.getTableDataManagerType())) {
            case OFFLINE: {
                if (tableDataManagerConfig.isDimTable()) {
                    tableDataManager = DimensionTableDataManager.createInstanceByTableName(tableDataManagerConfig.getTableName());
                    break;
                }
                tableDataManager = new OfflineTableDataManager();
                break;
            }
            case REALTIME: {
                tableDataManager = new RealtimeTableDataManager(_segmentBuildSemaphore);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        tableDataManager.init(tableDataManagerConfig, instanceId, propertyStore, serverMetrics, helixManager, errorCache, _tableDataManagerParams);
        return tableDataManager;
    }
}

