/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.core.data.manager.realtime.RealtimeConsumptionRateManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitterFactory;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.realtime.converter.RealtimeSegmentConverter;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunctionFactory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.CompletionConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentZKPropsConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.PartitionGroupConsumer;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.apache.pinot.spi.stream.PermanentConsumerException;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamDecoderProvider;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffsetFactory;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLRealtimeSegmentDataManager
extends RealtimeSegmentDataManager {
    private static final int MINIMUM_CONSUME_TIME_MINUTES = 10;
    private static final long TIME_THRESHOLD_FOR_LOG_MINUTES = 1L;
    private static final long TIME_EXTENSION_ON_EMPTY_SEGMENT_HOURS = 1L;
    private static final int MSG_COUNT_THRESHOLD_FOR_LOG = 100000;
    private static final int BUILD_TIME_LEASE_SECONDS = 30;
    private static final int MAX_CONSECUTIVE_ERROR_COUNT = 5;
    private final SegmentZKMetadata _segmentZKMetadata;
    private final TableConfig _tableConfig;
    private final RealtimeTableDataManager _realtimeTableDataManager;
    private final StreamMessageDecoder _messageDecoder;
    private final int _segmentMaxRowCount;
    private final String _resourceDataDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final Semaphore _partitionGroupConsumerSemaphore;
    private final AtomicBoolean _acquiredConsumerSemaphore;
    private final String _metricKeyName;
    private final ServerMetrics _serverMetrics;
    private final MutableSegmentImpl _realtimeSegment;
    private volatile StreamPartitionMsgOffset _currentOffset;
    private volatile State _state;
    private volatile int _numRowsConsumed = 0;
    private volatile int _numRowsIndexed = 0;
    private volatile int _numRowsErrored = 0;
    private volatile int _consecutiveErrorCount = 0;
    private long _startTimeMs = 0L;
    private final String _segmentNameStr;
    private final SegmentVersion _segmentVersion;
    private final SegmentBuildTimeLeaseExtender _leaseExtender;
    private SegmentBuildDescriptor _segmentBuildDescriptor;
    private final StreamConsumerFactory _streamConsumerFactory;
    private final StreamPartitionMsgOffsetFactory _streamPartitionMsgOffsetFactory;
    private volatile long _consumeEndTime = 0L;
    private volatile boolean _hasMessagesFetched = false;
    private volatile boolean _endOfPartitionGroup = false;
    private volatile boolean _forceCommitMessageReceived = false;
    private StreamPartitionMsgOffset _finalOffset;
    private volatile boolean _shouldStop = false;
    private static final int MAX_TIME_FOR_CONSUMING_TO_ONLINE_IN_SECONDS = 31;
    private Thread _consumerThread;
    private final int _partitionGroupId;
    private final PartitionGroupConsumptionStatus _partitionGroupConsumptionStatus;
    final String _clientId;
    private final LLCSegmentName _llcSegmentName;
    private final TransformPipeline _transformPipeline;
    private PartitionGroupConsumer _partitionGroupConsumer = null;
    private StreamMetadataProvider _streamMetadataProvider = null;
    private final File _resourceTmpDir;
    private final String _tableNameWithType;
    private final List<String> _invertedIndexColumns;
    private final List<String> _textIndexColumns;
    private final List<String> _fstIndexColumns;
    private final List<String> _noDictionaryColumns;
    private final List<String> _varLengthDictionaryColumns;
    private final String _sortedColumn;
    private final Logger _segmentLogger;
    private final String _tableStreamName;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final AtomicLong _lastUpdatedRowsIndexed = new AtomicLong(0L);
    private final String _instanceId;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final long _consumeStartTime;
    private final StreamPartitionMsgOffset _startOffset;
    private final PartitionLevelStreamConfig _partitionLevelStreamConfig;
    private long _lastLogTime = 0L;
    private int _lastConsumedCount = 0;
    private String _stopReason = null;
    private final Semaphore _segBuildSemaphore;
    private final boolean _isOffHeap;
    private final boolean _nullHandlingEnabled;
    private final SegmentCommitterFactory _segmentCommitterFactory;
    private final RealtimeConsumptionRateManager.ConsumptionRateLimiter _rateLimiter;
    private volatile StreamPartitionMsgOffset _latestStreamOffsetAtStartupTime = null;

    private boolean endCriteriaReached() {
        Preconditions.checkState((boolean)this._state.shouldConsume(), (String)"Incorrect state %s", (Object)((Object)this._state));
        long now = this.now();
        switch (this._state) {
            case INITIAL_CONSUMING: {
                if (now >= this._consumeEndTime) {
                    if (!this._hasMessagesFetched) {
                        this._segmentLogger.info("No events came in, extending time by {} hours", (Object)1L);
                        this._consumeEndTime += TimeUnit.HOURS.toMillis(1L);
                        return false;
                    }
                    this._segmentLogger.info("Stopping consumption due to time limit start={} now={} numRowsConsumed={} numRowsIndexed={}", new Object[]{this._startTimeMs, now, this._numRowsConsumed, this._numRowsIndexed});
                    this._stopReason = "timeLimit";
                    return true;
                }
                if (this._numRowsIndexed >= this._segmentMaxRowCount) {
                    this._segmentLogger.info("Stopping consumption due to row limit nRows={} numRowsIndexed={}, numRowsConsumed={}", new Object[]{this._segmentMaxRowCount, this._numRowsIndexed, this._numRowsConsumed});
                    this._stopReason = "rowLimit";
                    return true;
                }
                if (this._endOfPartitionGroup) {
                    this._segmentLogger.info("Stopping consumption due to end of partitionGroup reached nRows={} numRowsIndexed={}, numRowsConsumed={}", new Object[]{this._segmentMaxRowCount, this._numRowsIndexed, this._numRowsConsumed});
                    this._stopReason = "endOfPartitionGroup";
                    return true;
                }
                if (this._forceCommitMessageReceived) {
                    this._segmentLogger.info("Stopping consumption due to force commit - numRowsConsumed={} numRowsIndexed={}", (Object)this._numRowsConsumed, (Object)this._numRowsIndexed);
                    this._stopReason = "forceCommitMessageReceived";
                    return true;
                }
                return false;
            }
            case CATCHING_UP: {
                this._stopReason = null;
                if (this._currentOffset.compareTo((Object)this._finalOffset) == 0) {
                    this._segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset.compareTo((Object)this._finalOffset) > 0) {
                    this._segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
            case CONSUMING_TO_ONLINE: {
                if (this._currentOffset.compareTo((Object)this._finalOffset) == 0) {
                    this._segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (now >= this._consumeEndTime) {
                    this._segmentLogger.info("Past max time budget: offset={}, state={}", (Object)this._currentOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset.compareTo((Object)this._finalOffset) > 0) {
                    this._segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
        }
        this._segmentLogger.error("Illegal state {}" + this._state.toString());
        throw new RuntimeException("Illegal state to consume");
    }

    private void handleTransientStreamErrors(Exception e) throws Exception {
        ++this._consecutiveErrorCount;
        if (this._consecutiveErrorCount > 5) {
            this._segmentLogger.warn("Stream transient exception when fetching messages, stopping consumption after {} attempts", (Object)this._consecutiveErrorCount, (Object)e);
            throw e;
        }
        this._segmentLogger.warn("Stream transient exception when fetching messages, retrying (count={})", (Object)this._consecutiveErrorCount, (Object)e);
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.recreateStreamConsumer("Too many transient errors");
    }

    protected boolean consumeLoop() throws Exception {
        this._numRowsErrored = 0;
        long idlePipeSleepTimeMillis = 100L;
        long idleTimeoutMillis = this._partitionLevelStreamConfig.getIdleTimeoutMillis();
        long idleStartTimeMillis = -1L;
        boolean idle = false;
        StreamPartitionMsgOffset lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(this._currentOffset);
        this.removeSegmentFile();
        this._segmentLogger.info("Starting consumption loop start offset {}, finalOffset {}", (Object)this._currentOffset, (Object)this._finalOffset);
        while (!this._shouldStop && !this.endCriteriaReached()) {
            MessageBatch messageBatch;
            try {
                messageBatch = this._partitionGroupConsumer.fetchMessages(this._currentOffset, null, this._partitionLevelStreamConfig.getFetchTimeoutMillis());
                if (this._segmentLogger.isDebugEnabled()) {
                    this._segmentLogger.debug("message batch received. filtered={} unfiltered={} endOfPartitionGroup={}", new Object[]{messageBatch.getMessageCount(), messageBatch.getUnfilteredMessageCount(), messageBatch.isEndOfPartitionGroup()});
                }
                this._endOfPartitionGroup = messageBatch.isEndOfPartitionGroup();
                this._consecutiveErrorCount = 0;
            }
            catch (PermanentConsumerException e) {
                this._segmentLogger.warn("Permanent exception from stream when fetching messages, stopping consumption", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            boolean endCriteriaReached = this.processStreamEvents(messageBatch, 100L);
            if (this._currentOffset.compareTo((Object)lastUpdatedOffset) != 0) {
                idle = false;
                if (this._currentOffset instanceof LongMsgOffset) {
                    this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.HIGHEST_STREAM_OFFSET_CONSUMED, ((LongMsgOffset)this._currentOffset).getOffset());
                }
                this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 1L);
                lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(this._currentOffset);
            } else if (endCriteriaReached) {
                if (this._segmentLogger.isDebugEnabled()) {
                    this._segmentLogger.debug("No messages processed before end criteria was reached. Staying at offset {}", (Object)this._currentOffset);
                }
            } else if (messageBatch.getUnfilteredMessageCount() > 0) {
                idle = false;
                StreamPartitionMsgOffset nextOffset = messageBatch.getOffsetOfNextBatch();
                if (this._segmentLogger.isDebugEnabled()) {
                    this._segmentLogger.debug("Skipped empty batch. Advancing from {} to {}", (Object)this._currentOffset, (Object)nextOffset);
                }
                this._currentOffset = nextOffset;
                lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(nextOffset);
            } else {
                long totalIdleTimeMillis;
                if (!idle) {
                    idleStartTimeMillis = this.now();
                    idle = true;
                }
                if (idleTimeoutMillis >= 0L && (totalIdleTimeMillis = this.now() - idleStartTimeMillis) > idleTimeoutMillis) {
                    this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 1L);
                    this.recreateStreamConsumer(String.format("Total idle time: %d ms exceeded idle timeout: %d ms", totalIdleTimeMillis, idleTimeoutMillis));
                    idle = false;
                }
            }
            if (!endCriteriaReached) continue;
            break;
        }
        if (this._numRowsErrored > 0) {
            this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)this._numRowsErrored);
            this._serverMetrics.addMeteredTableValue(this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)this._numRowsErrored);
        }
        return true;
    }

    private boolean processStreamEvents(MessageBatch messagesAndOffsets, long idlePipeSleepTimeMillis) {
        int messageCount = messagesAndOffsets.getMessageCount();
        this._rateLimiter.throttle(messageCount);
        PinotMeter realtimeRowsConsumedMeter = null;
        PinotMeter realtimeRowsDroppedMeter = null;
        int indexedMessageCount = 0;
        int streamMessageCount = 0;
        boolean canTakeMore = true;
        GenericRow reuse = new GenericRow();
        TransformPipeline.Result reusedResult = new TransformPipeline.Result();
        boolean prematureExit = false;
        for (int index = 0; index < messageCount; ++index) {
            boolean bl = prematureExit = this._shouldStop || this.endCriteriaReached();
            if (prematureExit) {
                if (!this._segmentLogger.isDebugEnabled()) break;
                this._segmentLogger.debug("stop processing message batch early shouldStop: {}", (Object)this._shouldStop);
                break;
            }
            if (!canTakeMore) {
                this._segmentLogger.error("Buffer full with {} rows consumed (row limit {}, indexed {})", new Object[]{this._numRowsConsumed, this._numRowsIndexed, this._segmentMaxRowCount});
                throw new RuntimeException("Realtime segment full");
            }
            reuse.clear();
            RowMetadata msgMetadata = messagesAndOffsets.getMetadataAtIndex(index);
            GenericRow decodedRow = this._messageDecoder.decode(messagesAndOffsets.getMessageAtIndex(index), messagesAndOffsets.getMessageOffsetAtIndex(index), messagesAndOffsets.getMessageLengthAtIndex(index), reuse);
            if (decodedRow != null) {
                try {
                    this._transformPipeline.processRow(decodedRow, reusedResult);
                }
                catch (Exception e) {
                    ++this._numRowsErrored;
                    reusedResult.getTransformedRows().clear();
                    String errorMessage = String.format("Caught exception while transforming the record: %s", decodedRow);
                    this._segmentLogger.error(errorMessage, (Throwable)e);
                    this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, e));
                }
                if (reusedResult.getSkippedRowCount() > 0) {
                    realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.INVALID_REALTIME_ROWS_DROPPED, (long)reusedResult.getSkippedRowCount(), realtimeRowsDroppedMeter);
                }
                for (GenericRow transformedRow : reusedResult.getTransformedRows()) {
                    try {
                        canTakeMore = this._realtimeSegment.index(transformedRow, msgMetadata);
                        ++indexedMessageCount;
                        realtimeRowsConsumedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L, realtimeRowsConsumedMeter);
                    }
                    catch (Exception e) {
                        ++this._numRowsErrored;
                        String errorMessage = String.format("Caught exception while indexing the record: %s", transformedRow);
                        this._segmentLogger.error(errorMessage, (Throwable)e);
                        this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, e));
                    }
                }
            } else {
                realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
            }
            this._currentOffset = messagesAndOffsets.getNextStreamPartitionMsgOffsetAtIndex(index);
            this._numRowsIndexed = this._realtimeSegment.getNumDocsIndexed();
            ++this._numRowsConsumed;
            ++streamMessageCount;
        }
        this.updateCurrentDocumentCountMetrics();
        if (messagesAndOffsets.getUnfilteredMessageCount() > 0) {
            this._hasMessagesFetched = true;
            if (streamMessageCount > 0 && this._segmentLogger.isDebugEnabled()) {
                this._segmentLogger.debug("Indexed {} messages ({} messages read from stream) current offset {}", new Object[]{indexedMessageCount, streamMessageCount, this._currentOffset});
            }
        } else if (!prematureExit) {
            if (this._segmentLogger.isDebugEnabled()) {
                this._segmentLogger.debug("empty batch received - sleeping for {}ms", (Object)idlePipeSleepTimeMillis);
            }
            Uninterruptibles.sleepUninterruptibly((long)idlePipeSleepTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return prematureExit;
    }

    private CommonConstants.Segment.Realtime.CompletionMode getSegmentCompletionMode() {
        CompletionConfig completionConfig = this._tableConfig.getValidationConfig().getCompletionConfig();
        if (completionConfig != null && CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD.toString().equalsIgnoreCase(completionConfig.getCompletionMode())) {
            return CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD;
        }
        return CommonConstants.Segment.Realtime.CompletionMode.DEFAULT;
    }

    @VisibleForTesting
    protected StreamPartitionMsgOffset extractOffset(SegmentCompletionProtocol.Response response) {
        if (response.getStreamPartitionMsgOffset() != null) {
            return this._streamPartitionMsgOffsetFactory.create(response.getStreamPartitionMsgOffset());
        }
        return this._streamPartitionMsgOffsetFactory.create(Long.toString(response.getOffset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSegmentForCommit(long buildTimeLeaseMs) {
        try {
            File segmentTarFile;
            if (this._segmentBuildDescriptor != null && this._segmentBuildDescriptor.getOffset().compareTo((Object)this._currentOffset) == 0 && (segmentTarFile = this._segmentBuildDescriptor.getSegmentTarFile()) != null && segmentTarFile.exists()) {
                return;
            }
            this.removeSegmentFile();
            if (buildTimeLeaseMs <= 0L) {
                buildTimeLeaseMs = this._segBuildSemaphore == null ? (long)SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds() * 1000L : 30000L;
            }
            this._leaseExtender.addSegment(this._segmentNameStr, buildTimeLeaseMs, this._currentOffset);
            this._segmentBuildDescriptor = this.buildSegmentInternal(true);
        }
        finally {
            this._leaseExtender.removeSegment(this._segmentNameStr);
        }
    }

    @Override
    public Map<String, String> getPartitionToCurrentOffset() {
        HashMap<String, String> partitionToCurrentOffset = new HashMap<String, String>();
        partitionToCurrentOffset.put(String.valueOf(this._partitionGroupId), this._currentOffset.toString());
        return partitionToCurrentOffset;
    }

    @Override
    public CommonConstants.ConsumerState getConsumerState() {
        return this._state == State.ERROR ? CommonConstants.ConsumerState.NOT_CONSUMING : CommonConstants.ConsumerState.CONSUMING;
    }

    @Override
    public long getLastConsumedTimestamp() {
        return this._lastLogTime;
    }

    public StreamPartitionMsgOffset getCurrentOffset() {
        return this._currentOffset;
    }

    public StreamPartitionMsgOffset getLatestStreamOffsetAtStartupTime() {
        return this._latestStreamOffsetAtStartupTime;
    }

    @VisibleForTesting
    protected SegmentBuildDescriptor getSegmentBuildDescriptor() {
        return this._segmentBuildDescriptor;
    }

    @VisibleForTesting
    protected Semaphore getPartitionGroupConsumerSemaphore() {
        return this._partitionGroupConsumerSemaphore;
    }

    @VisibleForTesting
    protected AtomicBoolean getAcquiredConsumerSemaphore() {
        return this._acquiredConsumerSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SegmentBuildDescriptor buildSegmentInternal(boolean forCommit) {
        long segmentSizeBytes;
        File indexDir;
        File dataDir;
        long waitTimeMillis;
        long buildTimeMillis;
        File tempSegmentFolder;
        this.closeStreamConsumers();
        try {
            long startTimeMillis = this.now();
            if (this._segBuildSemaphore != null) {
                this._segmentLogger.info("Waiting to acquire semaphore for building segment");
                this._segBuildSemaphore.acquire();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, 1L);
            long lockAcquireTimeMillis = this.now();
            tempSegmentFolder = new File(this._resourceTmpDir, "tmp-" + this._segmentNameStr + "-" + this.now());
            SegmentZKPropsConfig segmentZKPropsConfig = new SegmentZKPropsConfig();
            segmentZKPropsConfig.setStartOffset(this._segmentZKMetadata.getStartOffset());
            segmentZKPropsConfig.setEndOffset(this._currentOffset.toString());
            RealtimeSegmentConverter converter = new RealtimeSegmentConverter(this._realtimeSegment, segmentZKPropsConfig, tempSegmentFolder.getAbsolutePath(), this._schema, this._tableNameWithType, this._tableConfig, this._segmentZKMetadata.getSegmentName(), this._sortedColumn, this._invertedIndexColumns, this._textIndexColumns, this._fstIndexColumns, this._noDictionaryColumns, this._varLengthDictionaryColumns, this._nullHandlingEnabled);
            this._segmentLogger.info("Trying to build segment");
            try {
                converter.build(this._segmentVersion, this._serverMetrics);
            }
            catch (Exception e) {
                this._segmentLogger.error("Could not build segment", (Throwable)e);
                FileUtils.deleteQuietly((File)tempSegmentFolder);
                this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), "Could not build segment", e));
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            buildTimeMillis = this.now() - lockAcquireTimeMillis;
            waitTimeMillis = lockAcquireTimeMillis - startTimeMillis;
            this._segmentLogger.info("Successfully built segment in {} ms, after lockWaitTime {} ms", (Object)buildTimeMillis, (Object)waitTimeMillis);
            dataDir = new File(this._resourceDataDir);
            indexDir = new File(dataDir, this._segmentNameStr);
            FileUtils.deleteQuietly((File)indexDir);
            File[] tempFiles = tempSegmentFolder.listFiles();
            assert (tempFiles != null);
            File tempIndexDir = tempFiles[0];
            try {
                FileUtils.moveDirectory((File)tempIndexDir, (File)indexDir);
            }
            catch (IOException e) {
                String errorMessage = String.format("Caught exception while moving index directory from: %s to: %s", tempIndexDir, indexDir);
                this._segmentLogger.error(errorMessage, (Throwable)e);
                this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, (Exception)e));
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            segmentSizeBytes = FileUtils.sizeOfDirectory((File)indexDir);
        }
        catch (InterruptedException e) {
            String errorMessage = "Interrupted while waiting for semaphore";
            this._segmentLogger.error(errorMessage, (Throwable)e);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, (Exception)e));
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            return segmentBuildDescriptor;
        }
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CREATION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(buildTimeMillis));
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CREATION_WAIT_TIME_SECONDS, TimeUnit.MILLISECONDS.toSeconds(waitTimeMillis));
        if (!forCommit) return new SegmentBuildDescriptor(null, null, this._currentOffset, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
        File segmentTarFile = new File(dataDir, this._segmentNameStr + ".tar.gz");
        try {
            TarGzCompressionUtils.createTarGzFile((File)indexDir, (File)segmentTarFile);
        }
        catch (IOException e) {
            String errorMessage = String.format("Caught exception while taring index directory from: %s to: %s", indexDir, segmentTarFile);
            this._segmentLogger.error(errorMessage, (Throwable)e);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, (Exception)e));
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
            return segmentBuildDescriptor;
        }
        File metadataFile = SegmentDirectoryPaths.findMetadataFile((File)indexDir);
        if (metadataFile == null) {
            String errorMessage = String.format("Failed to find file: %s under index directory: %s", "metadata.properties", indexDir);
            this._segmentLogger.error(errorMessage);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, null));
            return null;
        }
        File creationMetaFile = SegmentDirectoryPaths.findCreationMetaFile((File)indexDir);
        if (creationMetaFile == null) {
            String errorMessage = String.format("Failed to find file: %s under index directory: %s", "creation.meta", indexDir);
            this._segmentLogger.error(errorMessage);
            this._realtimeTableDataManager.addSegmentError(this._segmentNameStr, new SegmentErrorInfo(this.now(), errorMessage, null));
            return null;
        }
        HashMap<String, File> metadataFiles = new HashMap<String, File>();
        metadataFiles.put("metadata.properties", metadataFile);
        metadataFiles.put("creation.meta", creationMetaFile);
        return new SegmentBuildDescriptor(segmentTarFile, metadataFiles, this._currentOffset, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
        finally {
            FileUtils.deleteQuietly((File)tempSegmentFolder);
        }
        finally {
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
        }
    }

    protected boolean commitSegment(String controllerVipUrl, boolean isSplitCommit) {
        File segmentTarFile = this._segmentBuildDescriptor.getSegmentTarFile();
        if (segmentTarFile == null || !segmentTarFile.exists()) {
            throw new RuntimeException("Segment file does not exist: " + segmentTarFile);
        }
        SegmentCompletionProtocol.Response commitResponse = this.commit(controllerVipUrl, isSplitCommit);
        if (!commitResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            return false;
        }
        this._realtimeTableDataManager.replaceLLSegment(this._segmentNameStr, this._indexLoadingConfig);
        this.removeSegmentFile();
        return true;
    }

    protected SegmentCompletionProtocol.Response commit(String controllerVipUrl, boolean isSplitCommit) {
        SegmentCommitter segmentCommitter;
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withSegmentName(this._segmentNameStr).withStreamPartitionMsgOffset(this._currentOffset.toString()).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId).withBuildTimeMillis(this._segmentBuildDescriptor.getBuildTimeMillis()).withSegmentSizeBytes(this._segmentBuildDescriptor.getSegmentSizeBytes()).withWaitTimeMillis(this._segmentBuildDescriptor.getWaitTimeMillis());
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        try {
            segmentCommitter = this._segmentCommitterFactory.createSegmentCommitter(isSplitCommit, params, controllerVipUrl);
        }
        catch (URISyntaxException e) {
            this._segmentLogger.error("Failed to create a segment committer: ", (Throwable)e);
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return segmentCommitter.commit(this._segmentBuildDescriptor);
    }

    protected boolean buildSegmentAndReplace() {
        SegmentBuildDescriptor descriptor = this.buildSegmentInternal(false);
        if (descriptor == null) {
            return false;
        }
        this._realtimeTableDataManager.replaceLLSegment(this._segmentNameStr, this._indexLoadingConfig);
        return true;
    }

    private void closeStreamConsumers() {
        this.closePartitionGroupConsumer();
        this.closeStreamMetadataProvider();
        if (this._acquiredConsumerSemaphore.compareAndSet(true, false)) {
            this._partitionGroupConsumerSemaphore.release();
        }
    }

    private void closePartitionGroupConsumer() {
        try {
            this._partitionGroupConsumer.close();
        }
        catch (Exception e) {
            this._segmentLogger.warn("Could not close stream consumer", (Throwable)e);
        }
    }

    private void closeStreamMetadataProvider() {
        try {
            this._streamMetadataProvider.close();
        }
        catch (Exception e) {
            this._segmentLogger.warn("Could not close stream metadata provider", (Throwable)e);
        }
    }

    private void cleanupMetrics() {
        this._serverMetrics.removeTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING);
    }

    protected void hold() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            this._segmentLogger.warn("Interrupted while holding");
        }
    }

    protected void postStopConsumedMsg(String reason) {
        do {
            SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
            params.withStreamPartitionMsgOffset(this._currentOffset.toString()).withReason(reason).withSegmentName(this._segmentNameStr).withInstanceId(this._instanceId);
            SegmentCompletionProtocol.Response response = this._protocolHandler.segmentStoppedConsuming(params);
            if (response.getStatus() == SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED) {
                this._segmentLogger.info("Got response {}", (Object)response.toJsonString());
                break;
            }
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            this._segmentLogger.info("Retrying after response {}", (Object)response.toJsonString());
        } while (!this._shouldStop);
    }

    protected SegmentCompletionProtocol.Response postSegmentConsumedMsg() {
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withStreamPartitionMsgOffset(this._currentOffset.toString()).withSegmentName(this._segmentNameStr).withReason(this._stopReason).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId);
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        return this._protocolHandler.segmentConsumed(params);
    }

    private void removeSegmentFile() {
        if (this._segmentBuildDescriptor != null) {
            this._segmentBuildDescriptor.deleteSegmentFile();
            this._segmentBuildDescriptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void goOnlineFromConsuming(SegmentZKMetadata segmentZKMetadata) throws InterruptedException {
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        try {
            this.removeSegmentFile();
            this._leaseExtender.removeSegment(this._segmentNameStr);
            StreamPartitionMsgOffset endOffset = this._streamPartitionMsgOffsetFactory.create(segmentZKMetadata.getEndOffset());
            this._segmentLogger.info("State: {}, transitioning from CONSUMING to ONLINE (startOffset: {}, endOffset: {})", new Object[]{this._state.toString(), this._startOffset, endOffset});
            this.stop();
            this._segmentLogger.info("Consumer thread stopped in state {}", (Object)this._state.toString());
            switch (this._state) {
                case COMMITTED: 
                case RETAINED: {
                    this._segmentLogger.info("State {}. Nothing to do", (Object)this._state.toString());
                    return;
                }
                case DISCARDED: 
                case ERROR: {
                    this._segmentLogger.info("State {}. Downloading to replace", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(segmentZKMetadata);
                    return;
                }
                case INITIAL_CONSUMING: 
                case CATCHING_UP: 
                case HOLDING: {
                    CommonConstants.Segment.Realtime.CompletionMode segmentCompletionMode = this.getSegmentCompletionMode();
                    switch (segmentCompletionMode) {
                        case DOWNLOAD: {
                            this._segmentLogger.info("State {}. CompletionMode {}. Downloading to replace", (Object)this._state.toString(), (Object)segmentCompletionMode);
                            this.downloadSegmentAndReplace(segmentZKMetadata);
                            return;
                        }
                        case DEFAULT: {
                            if (this._currentOffset.compareTo((Object)endOffset) > 0) {
                                this._segmentLogger.warn("Current offset {} ahead of the offset in zk {}. Downloading to replace", (Object)this._currentOffset, (Object)endOffset);
                                this.downloadSegmentAndReplace(segmentZKMetadata);
                                return;
                            } else if (this._currentOffset.compareTo((Object)endOffset) == 0) {
                                this._segmentLogger.info("Current offset {} matches offset in zk {}. Replacing segment", (Object)this._currentOffset, (Object)endOffset);
                                this.buildSegmentAndReplace();
                                return;
                            } else {
                                this._segmentLogger.info("Attempting to catch up from offset {} to {} ", (Object)this._currentOffset, (Object)endOffset);
                                boolean success = this.catchupToFinalOffset(endOffset, TimeUnit.MILLISECONDS.convert(31L, TimeUnit.SECONDS));
                                if (success) {
                                    this._segmentLogger.info("Caught up to offset {}", (Object)this._currentOffset);
                                    this.buildSegmentAndReplace();
                                    return;
                                } else {
                                    this._segmentLogger.info("Could not catch up to offset (current = {}). Downloading to replace", (Object)this._currentOffset);
                                    this.downloadSegmentAndReplace(segmentZKMetadata);
                                    return;
                                }
                            }
                        }
                    }
                    return;
                }
                default: {
                    this._segmentLogger.info("Downloading to replace segment while in state {}", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(segmentZKMetadata);
                    return;
                }
            }
        }
        catch (Exception e) {
            Utils.rethrowException((Throwable)e);
            return;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
    }

    protected void downloadSegmentAndReplace(SegmentZKMetadata segmentZKMetadata) {
        this.closeStreamConsumers();
        this._realtimeTableDataManager.downloadAndReplaceSegment(this._segmentNameStr, segmentZKMetadata, this._indexLoadingConfig, this._tableConfig);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean catchupToFinalOffset(StreamPartitionMsgOffset endOffset, long timeoutMs) {
        this._finalOffset = endOffset;
        this._consumeEndTime = this.now() + timeoutMs;
        this._state = State.CONSUMING_TO_ONLINE;
        this._shouldStop = false;
        try {
            this.consumeLoop();
        }
        catch (Exception e) {
            this._segmentLogger.warn("Exception when catching up to final offset", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
        if (this._currentOffset.compareTo((Object)endOffset) != 0) {
            this._segmentLogger.warn("Could not consume up to {} (current offset {})", (Object)endOffset, (Object)this._currentOffset);
            return false;
        }
        return true;
    }

    public void destroy() {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            this._segmentLogger.error("Could not stop consumer thread");
        }
        this._realtimeSegment.destroy();
        this.closeStreamConsumers();
        this.cleanupMetrics();
    }

    protected void startConsumerThread() {
        this._consumerThread = new Thread((Runnable)new PartitionConsumer(), this._segmentNameStr);
        this._segmentLogger.info("Created new consumer thread {} for {}", (Object)this._consumerThread, (Object)this);
        this._consumerThread.start();
    }

    public void stop() throws InterruptedException {
        this._shouldStop = true;
        if (Thread.currentThread() != this._consumerThread) {
            Uninterruptibles.joinUninterruptibly((Thread)this._consumerThread, (long)10L, (TimeUnit)TimeUnit.MINUTES);
            if (this._consumerThread.isAlive()) {
                this._segmentLogger.warn("Failed to stop consumer thread within 10 minutes");
            }
        }
    }

    public LLRealtimeSegmentDataManager(SegmentZKMetadata segmentZKMetadata, TableConfig tableConfig, RealtimeTableDataManager realtimeTableDataManager, String resourceDataDir, IndexLoadingConfig indexLoadingConfig, Schema schema, LLCSegmentName llcSegmentName, Semaphore partitionGroupConsumerSemaphore, ServerMetrics serverMetrics, @Nullable PartitionUpsertMetadataManager partitionUpsertMetadataManager, @Nullable PartitionDedupMetadataManager partitionDedupMetadataManager) {
        this._segBuildSemaphore = realtimeTableDataManager.getSegmentBuildSemaphore();
        this._segmentZKMetadata = segmentZKMetadata;
        this._tableConfig = tableConfig;
        this._tableNameWithType = this._tableConfig.getTableName();
        this._realtimeTableDataManager = realtimeTableDataManager;
        this._resourceDataDir = resourceDataDir;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._serverMetrics = serverMetrics;
        this._segmentVersion = indexLoadingConfig.getSegmentVersion();
        this._instanceId = this._realtimeTableDataManager.getServerInstance();
        this._leaseExtender = SegmentBuildTimeLeaseExtender.getLeaseExtender(this._tableNameWithType);
        this._protocolHandler = new ServerSegmentCompletionProtocolHandler(this._serverMetrics, this._tableNameWithType);
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        IndexingConfig indexingConfig = this._tableConfig.getIndexingConfig();
        this._partitionLevelStreamConfig = new PartitionLevelStreamConfig(this._tableNameWithType, IngestionConfigUtils.getStreamConfigMap((TableConfig)this._tableConfig));
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create((StreamConfig)this._partitionLevelStreamConfig);
        this._streamPartitionMsgOffsetFactory = StreamConsumerFactoryProvider.create((StreamConfig)this._partitionLevelStreamConfig).createStreamMsgOffsetFactory();
        String streamTopic = this._partitionLevelStreamConfig.getTopicName();
        this._segmentNameStr = this._segmentZKMetadata.getSegmentName();
        this._llcSegmentName = llcSegmentName;
        this._partitionGroupId = this._llcSegmentName.getPartitionGroupId();
        this._partitionGroupConsumptionStatus = new PartitionGroupConsumptionStatus(this._partitionGroupId, this._llcSegmentName.getSequenceNumber(), this._streamPartitionMsgOffsetFactory.create(this._segmentZKMetadata.getStartOffset()), this._segmentZKMetadata.getEndOffset() == null ? null : this._streamPartitionMsgOffsetFactory.create(this._segmentZKMetadata.getEndOffset()), this._segmentZKMetadata.getStatus().toString());
        this._partitionGroupConsumerSemaphore = partitionGroupConsumerSemaphore;
        this._acquiredConsumerSemaphore = new AtomicBoolean(false);
        this._metricKeyName = this._tableNameWithType + "-" + streamTopic + "-" + this._partitionGroupId;
        this._segmentLogger = LoggerFactory.getLogger((String)(LLRealtimeSegmentDataManager.class.getName() + "_" + this._segmentNameStr));
        this._tableStreamName = this._tableNameWithType + "_" + streamTopic;
        this._memoryManager = LLRealtimeSegmentDataManager.getMemoryManager(realtimeTableDataManager.getConsumerDir(), this._segmentNameStr, indexLoadingConfig.isRealtimeOffHeapAllocation(), indexLoadingConfig.isDirectRealtimeOffHeapAllocation(), serverMetrics);
        this._rateLimiter = RealtimeConsumptionRateManager.getInstance().createRateLimiter((StreamConfig)this._partitionLevelStreamConfig, this._tableNameWithType);
        List sortedColumns = indexLoadingConfig.getSortedColumns();
        if (sortedColumns.isEmpty()) {
            this._segmentLogger.info("RealtimeDataResourceZKMetadata contains no information about sorted column for segment {}", (Object)this._llcSegmentName);
            this._sortedColumn = null;
        } else {
            String firstSortedColumn = (String)sortedColumns.get(0);
            if (this._schema.hasColumn(firstSortedColumn)) {
                this._segmentLogger.info("Setting sorted column name: {} from RealtimeDataResourceZKMetadata for segment {}", (Object)firstSortedColumn, (Object)this._llcSegmentName);
                this._sortedColumn = firstSortedColumn;
            } else {
                this._segmentLogger.warn("Sorted column name: {} from RealtimeDataResourceZKMetadata is not existed in schema for segment {}.", (Object)firstSortedColumn, (Object)this._llcSegmentName);
                this._sortedColumn = null;
            }
        }
        Set invertedIndexColumns = indexLoadingConfig.getInvertedIndexColumns();
        if (this._sortedColumn != null) {
            invertedIndexColumns.add(this._sortedColumn);
        }
        this._invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        this._noDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getNoDictionaryColumns());
        this._varLengthDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getVarLengthDictionaryColumns());
        int segmentMaxRowCount = this._partitionLevelStreamConfig.getFlushThresholdRows();
        int flushThresholdSize = segmentZKMetadata.getSizeThresholdToFlushSegment();
        if (flushThresholdSize > 0) {
            segmentMaxRowCount = flushThresholdSize;
        }
        this._segmentMaxRowCount = segmentMaxRowCount;
        this._isOffHeap = indexLoadingConfig.isRealtimeOffHeapAllocation();
        this._nullHandlingEnabled = indexingConfig.isNullHandlingEnabled();
        Set textIndexColumns = indexLoadingConfig.getTextIndexColumns();
        this._textIndexColumns = new ArrayList<String>(textIndexColumns);
        Set fstIndexColumns = indexLoadingConfig.getFSTIndexColumns();
        this._fstIndexColumns = new ArrayList<String>(fstIndexColumns);
        String consumerDir = realtimeTableDataManager.getConsumerDir();
        RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder = new RealtimeSegmentConfig.Builder().setTableNameWithType(this._tableNameWithType).setSegmentName(this._segmentNameStr).setStreamName(streamTopic).setSchema(this._schema).setTimeColumnName(timeColumnName).setCapacity(this._segmentMaxRowCount).setAvgNumMultiValues(indexLoadingConfig.getRealtimeAvgMultiValueCount()).setNoDictionaryColumns(indexLoadingConfig.getNoDictionaryColumns()).setVarLengthDictionaryColumns(indexLoadingConfig.getVarLengthDictionaryColumns()).setInvertedIndexColumns(invertedIndexColumns).setTextIndexColumns(textIndexColumns).setFSTIndexColumns(fstIndexColumns).setJsonIndexColumns(indexLoadingConfig.getJsonIndexColumns()).setH3IndexConfigs(indexLoadingConfig.getH3IndexConfigs()).setSegmentZKMetadata(segmentZKMetadata).setOffHeap(this._isOffHeap).setMemoryManager(this._memoryManager).setStatsHistory(realtimeTableDataManager.getStatsHistory()).setAggregateMetrics(indexingConfig.isAggregateMetrics()).setIngestionAggregationConfigs(IngestionConfigUtils.getAggregationConfigs((TableConfig)tableConfig)).setNullHandlingEnabled(this._nullHandlingEnabled).setConsumerDir(consumerDir).setUpsertMode(tableConfig.getUpsertMode()).setPartitionUpsertMetadataManager(partitionUpsertMetadataManager).setPartitionDedupMetadataManager(partitionDedupMetadataManager).setUpsertComparisonColumn(tableConfig.getUpsertComparisonColumn()).setFieldConfigList(tableConfig.getFieldConfigList());
        Set fieldsToRead = IngestionUtils.getFieldsForRecordExtractor((IngestionConfig)this._tableConfig.getIngestionConfig(), (Schema)this._schema);
        this._messageDecoder = StreamDecoderProvider.create((StreamConfig)this._partitionLevelStreamConfig, (Set)fieldsToRead);
        this._clientId = streamTopic + "-" + this._partitionGroupId;
        this._transformPipeline = new TransformPipeline(tableConfig, schema);
        try {
            this._partitionGroupConsumerSemaphore.acquire();
            this._acquiredConsumerSemaphore.set(true);
        }
        catch (InterruptedException e) {
            String errorMsg = "InterruptedException when acquiring the partitionConsumerSemaphore";
            this._segmentLogger.error(errorMsg);
            throw new RuntimeException(errorMsg + " for segment: " + this._segmentNameStr);
        }
        try {
            this._startOffset = this._partitionGroupConsumptionStatus.getStartOffset();
            this._currentOffset = this._streamPartitionMsgOffsetFactory.create(this._startOffset);
            this.makeStreamConsumer("Starting");
            this.makeStreamMetadataProvider("Starting");
            this.setPartitionParameters(realtimeSegmentConfigBuilder, indexingConfig.getSegmentPartitionConfig());
            this._realtimeSegment = new MutableSegmentImpl(realtimeSegmentConfigBuilder.build(), serverMetrics);
            this._resourceTmpDir = new File(resourceDataDir, "_tmp");
            if (!this._resourceTmpDir.exists()) {
                this._resourceTmpDir.mkdirs();
            }
            this._state = State.INITIAL_CONSUMING;
            this.fetchLatestStreamOffset();
            this._consumeStartTime = this.now();
            this.setConsumeEndTime(segmentZKMetadata, this._consumeStartTime);
            this._segmentCommitterFactory = new SegmentCommitterFactory(this._segmentLogger, this._protocolHandler, tableConfig, indexLoadingConfig, serverMetrics);
            this._segmentLogger.info("Starting consumption on realtime consuming segment {} maxRowCount {} maxEndTime {}", new Object[]{this._llcSegmentName, this._segmentMaxRowCount, new DateTime(this._consumeEndTime, DateTimeZone.UTC)});
            this.startConsumerThread();
        }
        catch (Exception e) {
            this._partitionGroupConsumerSemaphore.release();
            throw e;
        }
    }

    private void setConsumeEndTime(SegmentZKMetadata segmentZKMetadata, long now) {
        long maxConsumeTimeMillis = this._partitionLevelStreamConfig.getFlushThresholdTimeMillis();
        this._consumeEndTime = segmentZKMetadata.getCreationTime() + maxConsumeTimeMillis;
        long minConsumeTimeMillis = Math.min(maxConsumeTimeMillis, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES));
        if (this._consumeEndTime - now < minConsumeTimeMillis) {
            this._consumeEndTime = now + minConsumeTimeMillis;
        }
    }

    private void fetchLatestStreamOffset() {
        try (StreamMetadataProvider metadataProvider = this._streamConsumerFactory.createPartitionMetadataProvider(this._clientId, this._partitionGroupId);){
            this._latestStreamOffsetAtStartupTime = metadataProvider.fetchStreamPartitionOffset(OffsetCriteria.LARGEST_OFFSET_CRITERIA, 5000L);
        }
        catch (Exception e) {
            this._segmentLogger.warn("Cannot fetch latest stream offset for clientId {} and partitionGroupId {}", (Object)this._clientId, (Object)this._partitionGroupId);
        }
    }

    private void setPartitionParameters(RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder, SegmentPartitionConfig segmentPartitionConfig) {
        if (segmentPartitionConfig != null) {
            Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            if (columnPartitionMap.size() == 1) {
                Map.Entry entry = columnPartitionMap.entrySet().iterator().next();
                String partitionColumn = (String)entry.getKey();
                ColumnPartitionConfig columnPartitionConfig = (ColumnPartitionConfig)entry.getValue();
                String partitionFunctionName = columnPartitionConfig.getFunctionName();
                int numPartitions = columnPartitionConfig.getNumPartitions();
                try {
                    int numPartitionGroups = this._streamMetadataProvider.computePartitionGroupMetadata(this._clientId, (StreamConfig)this._partitionLevelStreamConfig, Collections.emptyList(), 5000).size();
                    if (numPartitionGroups != numPartitions) {
                        this._segmentLogger.warn("Number of stream partitions: {} does not match number of partitions in the partition config: {}, using number of stream partitions", (Object)numPartitionGroups, (Object)numPartitions);
                        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.REALTIME_PARTITION_MISMATCH, 1L);
                        numPartitions = numPartitionGroups;
                    }
                }
                catch (Exception e) {
                    this._segmentLogger.warn("Failed to get number of stream partitions in 5s, using number of partitions in the partition config: {}", (Object)numPartitions, (Object)e);
                    this.makeStreamMetadataProvider("Timeout getting number of stream partitions");
                }
                realtimeSegmentConfigBuilder.setPartitionColumn(partitionColumn);
                realtimeSegmentConfigBuilder.setPartitionFunction(PartitionFunctionFactory.getPartitionFunction((String)partitionFunctionName, (int)numPartitions, null));
                realtimeSegmentConfigBuilder.setPartitionId(this._partitionGroupId);
            } else {
                this._segmentLogger.warn("Cannot partition on multiple columns: {}", columnPartitionMap.keySet());
            }
        }
    }

    private void makeStreamConsumer(String reason) {
        if (this._partitionGroupConsumer != null) {
            this.closePartitionGroupConsumer();
        }
        this._segmentLogger.info("Creating new stream consumer for topic partition {} , reason: {}", (Object)this._clientId, (Object)reason);
        this._partitionGroupConsumer = this._streamConsumerFactory.createPartitionGroupConsumer(this._clientId, this._partitionGroupConsumptionStatus);
        this._partitionGroupConsumer.start(this._currentOffset);
    }

    private void recreateStreamConsumer(String reason) {
        this._segmentLogger.warn("Recreating stream consumer for topic partition {}, reason: {}", (Object)this._clientId, (Object)reason);
        this._currentOffset = this._partitionGroupConsumer.checkpoint(this._currentOffset);
        this.closePartitionGroupConsumer();
        this._partitionGroupConsumer = this._streamConsumerFactory.createPartitionGroupConsumer(this._clientId, this._partitionGroupConsumptionStatus);
        this._partitionGroupConsumer.start(this._currentOffset);
    }

    private void makeStreamMetadataProvider(String reason) {
        if (this._streamMetadataProvider != null) {
            this.closeStreamMetadataProvider();
        }
        this._segmentLogger.info("Creating new stream metadata provider, reason: {}", (Object)reason);
        this._streamMetadataProvider = this._streamConsumerFactory.createStreamMetadataProvider(this._clientId);
    }

    private void updateCurrentDocumentCountMetrics() {
        long prevTime;
        long rowsIndexed = (long)this._numRowsIndexed - this._lastUpdatedRowsIndexed.get();
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, rowsIndexed);
        this._lastUpdatedRowsIndexed.set(this._numRowsIndexed);
        long now = this.now();
        int rowsConsumed = this._numRowsConsumed - this._lastConsumedCount;
        long l = prevTime = this._lastConsumedCount == 0 ? this._consumeStartTime : this._lastLogTime;
        if (now - prevTime > TimeUnit.MINUTES.toMillis(1L) || rowsConsumed >= 100000) {
            this._segmentLogger.info("Consumed {} events from (rate:{}/s), currentOffset={}, numRowsConsumedSoFar={}, numRowsIndexedSoFar={}", new Object[]{rowsConsumed, Float.valueOf((float)rowsConsumed * 1000.0f / (float)(now - prevTime)), this._currentOffset, this._numRowsConsumed, this._numRowsIndexed});
            this._lastConsumedCount = this._numRowsConsumed;
            this._lastLogTime = now;
        }
    }

    @Override
    public MutableSegment getSegment() {
        return this._realtimeSegment;
    }

    public String getSegmentName() {
        return this._segmentNameStr;
    }

    public void forceCommit() {
        this._forceCommitMessageReceived = true;
    }

    public class PartitionConsumer
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long initialConsumptionEnd = 0L;
            long lastCatchUpStart = 0L;
            long catchUpTimeMillis = 0L;
            LLRealtimeSegmentDataManager.this._startTimeMs = LLRealtimeSegmentDataManager.this.now();
            try {
                block14: while (!LLRealtimeSegmentDataManager.this._state.isFinal()) {
                    if (LLRealtimeSegmentDataManager.this._state.shouldConsume()) {
                        LLRealtimeSegmentDataManager.this.consumeLoop();
                    }
                    LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                    if (!LLRealtimeSegmentDataManager.this._shouldStop) {
                        if (LLRealtimeSegmentDataManager.this._state == State.INITIAL_CONSUMING) {
                            initialConsumptionEnd = LLRealtimeSegmentDataManager.this.now();
                            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_INITIAL_CONSUMPTION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(initialConsumptionEnd - LLRealtimeSegmentDataManager.this._startTimeMs));
                        } else if (LLRealtimeSegmentDataManager.this._state == State.CATCHING_UP) {
                            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CATCHUP_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(catchUpTimeMillis += LLRealtimeSegmentDataManager.this.now() - lastCatchUpStart));
                        }
                        LLRealtimeSegmentDataManager.this._state = State.HOLDING;
                        SegmentCompletionProtocol.Response response = LLRealtimeSegmentDataManager.this.postSegmentConsumedMsg();
                        SegmentCompletionProtocol.ControllerResponseStatus status = response.getStatus();
                        StreamPartitionMsgOffset rspOffset = LLRealtimeSegmentDataManager.this.extractOffset(response);
                        switch (status) {
                            case NOT_LEADER: {
                                LLRealtimeSegmentDataManager.this._segmentLogger.warn("Got not leader response");
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block14;
                            }
                            case CATCH_UP: {
                                if (rspOffset.compareTo((Object)LLRealtimeSegmentDataManager.this._currentOffset) <= 0) {
                                    LLRealtimeSegmentDataManager.this._segmentLogger.error("Invalid catchup offset {} in controller response, current offset {}", (Object)rspOffset, (Object)LLRealtimeSegmentDataManager.this._currentOffset);
                                    LLRealtimeSegmentDataManager.this.hold();
                                    continue block14;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.CATCHING_UP;
                                LLRealtimeSegmentDataManager.this._finalOffset = rspOffset;
                                lastCatchUpStart = LLRealtimeSegmentDataManager.this.now();
                                continue block14;
                            }
                            case HOLD: {
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block14;
                            }
                            case DISCARD: {
                                LLRealtimeSegmentDataManager.this._state = State.DISCARDED;
                                continue block14;
                            }
                            case KEEP: {
                                boolean success;
                                LLRealtimeSegmentDataManager.this._state = State.RETAINING;
                                CommonConstants.Segment.Realtime.CompletionMode segmentCompletionMode = LLRealtimeSegmentDataManager.this.getSegmentCompletionMode();
                                switch (segmentCompletionMode) {
                                    case DOWNLOAD: {
                                        LLRealtimeSegmentDataManager.this._state = State.DISCARDED;
                                        continue block14;
                                    }
                                    case DEFAULT: {
                                        success = LLRealtimeSegmentDataManager.this.buildSegmentAndReplace();
                                        if (success) {
                                            LLRealtimeSegmentDataManager.this._state = State.RETAINED;
                                            continue block14;
                                        }
                                        LLRealtimeSegmentDataManager.this._state = State.ERROR;
                                        LLRealtimeSegmentDataManager.this._segmentLogger.error("Could not build segment for {}", (Object)LLRealtimeSegmentDataManager.this._segmentNameStr);
                                        continue block14;
                                    }
                                }
                                continue block14;
                            }
                            case COMMIT: {
                                LLRealtimeSegmentDataManager.this._state = State.COMMITTING;
                                LLRealtimeSegmentDataManager.this._currentOffset = LLRealtimeSegmentDataManager.this._partitionGroupConsumer.checkpoint(LLRealtimeSegmentDataManager.this._currentOffset);
                                long buildTimeSeconds = response.getBuildTimeSeconds();
                                LLRealtimeSegmentDataManager.this.buildSegmentForCommit(buildTimeSeconds * 1000L);
                                if (LLRealtimeSegmentDataManager.this._segmentBuildDescriptor == null) {
                                    LLRealtimeSegmentDataManager.this._state = State.ERROR;
                                    LLRealtimeSegmentDataManager.this._segmentLogger.error("Could not build segment for {}", (Object)LLRealtimeSegmentDataManager.this._segmentNameStr);
                                    continue block14;
                                }
                                boolean success = LLRealtimeSegmentDataManager.this.commitSegment(response.getControllerVipUrl(), response.isSplitCommit() && LLRealtimeSegmentDataManager.this._indexLoadingConfig.isEnableSplitCommit());
                                if (success) {
                                    LLRealtimeSegmentDataManager.this._state = State.COMMITTED;
                                    continue block14;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.HOLDING;
                                LLRealtimeSegmentDataManager.this._segmentLogger.info("Could not commit segment. Retrying after hold");
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block14;
                            }
                        }
                        LLRealtimeSegmentDataManager.this._segmentLogger.error("Holding after response from Controller: {}", (Object)response.toJsonString());
                        LLRealtimeSegmentDataManager.this.hold();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                String errorMessage = "Exception while in work";
                LLRealtimeSegmentDataManager.this._segmentLogger.error(errorMessage, (Throwable)e);
                LLRealtimeSegmentDataManager.this.postStopConsumedMsg(e.getClass().getName());
                LLRealtimeSegmentDataManager.this._state = State.ERROR;
                LLRealtimeSegmentDataManager.this._realtimeTableDataManager.addSegmentError(LLRealtimeSegmentDataManager.this._segmentNameStr, new SegmentErrorInfo(LLRealtimeSegmentDataManager.this.now(), errorMessage, e));
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                return;
            }
            LLRealtimeSegmentDataManager.this.removeSegmentFile();
            if (initialConsumptionEnd != 0L) {
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_COMPLETION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(LLRealtimeSegmentDataManager.this.now() - initialConsumptionEnd));
            }
            if (!LLRealtimeSegmentDataManager.this._shouldStop) {
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
            }
        }
    }

    @VisibleForTesting
    public class SegmentBuildDescriptor {
        final File _segmentTarFile;
        final Map<String, File> _metadataFileMap;
        final StreamPartitionMsgOffset _offset;
        final long _waitTimeMillis;
        final long _buildTimeMillis;
        final long _segmentSizeBytes;

        public SegmentBuildDescriptor(@Nullable File segmentTarFile, Map<String, File> metadataFileMap, StreamPartitionMsgOffset offset, long buildTimeMillis, long waitTimeMillis, long segmentSizeBytes) {
            this._segmentTarFile = segmentTarFile;
            this._metadataFileMap = metadataFileMap;
            this._offset = LLRealtimeSegmentDataManager.this._streamPartitionMsgOffsetFactory.create(offset);
            this._buildTimeMillis = buildTimeMillis;
            this._waitTimeMillis = waitTimeMillis;
            this._segmentSizeBytes = segmentSizeBytes;
        }

        public StreamPartitionMsgOffset getOffset() {
            return this._offset;
        }

        public long getBuildTimeMillis() {
            return this._buildTimeMillis;
        }

        public long getWaitTimeMillis() {
            return this._waitTimeMillis;
        }

        @Nullable
        public File getSegmentTarFile() {
            return this._segmentTarFile;
        }

        @Nullable
        public Map<String, File> getMetadataFiles() {
            return this._metadataFileMap;
        }

        public long getSegmentSizeBytes() {
            return this._segmentSizeBytes;
        }

        public void deleteSegmentFile() {
            if (this._segmentTarFile != null) {
                FileUtils.deleteQuietly((File)this._segmentTarFile);
            }
        }
    }

    protected static enum State {
        INITIAL_CONSUMING,
        CATCHING_UP,
        HOLDING,
        CONSUMING_TO_ONLINE,
        RETAINING,
        COMMITTING,
        DISCARDED,
        RETAINED,
        COMMITTED,
        ERROR;


        public boolean shouldConsume() {
            return this.equals((Object)INITIAL_CONSUMING) || this.equals((Object)CATCHING_UP) || this.equals((Object)CONSUMING_TO_ONLINE);
        }

        public boolean isFinal() {
            return this.equals((Object)ERROR) || this.equals((Object)COMMITTED) || this.equals((Object)RETAINED) || this.equals((Object)DISCARDED);
        }
    }
}

