/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeConsumptionRateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeConsumptionRateManager.class);
    private static final int CACHE_ENTRY_EXPIRATION_TIME_IN_MINUTES = 10;
    private final LoadingCache<StreamConfig, Integer> _streamConfigToTopicPartitionCountMap;
    private volatile boolean _isThrottlingAllowed = false;
    @VisibleForTesting
    static final ConsumptionRateLimiter NOOP_RATE_LIMITER = n -> {};
    @VisibleForTesting
    static final PartitionCountFetcher DEFAULT_PARTITION_COUNT_FETCHER = streamConfig -> {
        Integer n;
        block8: {
            String clientId = streamConfig.getTopicName() + "-consumption.rate.manager";
            StreamConsumerFactory factory = StreamConsumerFactoryProvider.create((StreamConfig)streamConfig);
            StreamMetadataProvider streamMetadataProvider = factory.createStreamMetadataProvider(clientId);
            try {
                n = streamMetadataProvider.fetchPartitionCount(10000L);
                if (streamMetadataProvider == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (streamMetadataProvider != null) {
                        try {
                            streamMetadataProvider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Error fetching metadata for topic " + streamConfig.getTopicName(), (Throwable)e);
                    return null;
                }
            }
            streamMetadataProvider.close();
        }
        return n;
    };

    @VisibleForTesting
    RealtimeConsumptionRateManager(LoadingCache<StreamConfig, Integer> streamConfigToTopicPartitionCountMap) {
        this._streamConfigToTopicPartitionCountMap = streamConfigToTopicPartitionCountMap;
    }

    public static RealtimeConsumptionRateManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void enableThrottling() {
        this._isThrottlingAllowed = true;
    }

    public ConsumptionRateLimiter createRateLimiter(StreamConfig streamConfig, String tableName) {
        int partitionCount;
        if (!streamConfig.getTopicConsumptionRateLimit().isPresent()) {
            return NOOP_RATE_LIMITER;
        }
        try {
            partitionCount = (Integer)this._streamConfigToTopicPartitionCountMap.get((Object)streamConfig);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        double topicRateLimit = (Double)streamConfig.getTopicConsumptionRateLimit().get();
        double partitionRateLimit = topicRateLimit / (double)partitionCount;
        LOGGER.info("A consumption rate limiter is set up for topic {} in table {} with rate limit: {} (topic rate limit: {}, partition count: {})", new Object[]{streamConfig.getTopicName(), tableName, partitionRateLimit, topicRateLimit, partitionCount});
        return new RateLimiterImpl(partitionRateLimit);
    }

    @VisibleForTesting
    static LoadingCache<StreamConfig, Integer> buildCache(final PartitionCountFetcher partitionCountFetcher, long duration, TimeUnit unit) {
        return CacheBuilder.newBuilder().refreshAfterWrite(duration, unit).build((CacheLoader)new CacheLoader<StreamConfig, Integer>(){

            public Integer load(StreamConfig key) throws Exception {
                Integer count = partitionCountFetcher.fetch(key);
                return count != null ? count : 1;
            }

            public ListenableFuture<Integer> reload(StreamConfig key, Integer oldValue) throws Exception {
                Integer count = partitionCountFetcher.fetch(key);
                return Futures.immediateFuture((Object)(count != null ? count : oldValue));
            }
        });
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface PartitionCountFetcher {
        public Integer fetch(StreamConfig var1);
    }

    @VisibleForTesting
    static class RateLimiterImpl
    implements ConsumptionRateLimiter {
        private final double _rate;
        private final RateLimiter _rateLimiter;

        private RateLimiterImpl(double rate) {
            this._rate = rate;
            this._rateLimiter = RateLimiter.create((double)rate);
        }

        @Override
        public void throttle(int numMsgs) {
            if (InstanceHolder.INSTANCE._isThrottlingAllowed && numMsgs > 0) {
                this._rateLimiter.acquire(numMsgs);
            }
        }

        @VisibleForTesting
        double getRate() {
            return this._rate;
        }
    }

    @FunctionalInterface
    public static interface ConsumptionRateLimiter {
        public void throttle(int var1);
    }

    private static class InstanceHolder {
        private static final RealtimeConsumptionRateManager INSTANCE = new RealtimeConsumptionRateManager(RealtimeConsumptionRateManager.buildCache(DEFAULT_PARTITION_COUNT_FETCHER, 10L, TimeUnit.MINUTES));

        private InstanceHolder() {
        }
    }
}

