/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;

public class StAsTextFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "ST_AsText";
    private TransformFunction _transformFunction;
    private String[] _results;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 argument is required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The argument must be of bytes type");
        this._transformFunction = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return STRING_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new String[10000];
        }
        byte[][] values = this._transformFunction.transformToBytesValuesSV(projectionBlock);
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Geometry geometry = GeometrySerializer.deserialize((byte[])values[i]);
            this._results[i] = GeometryUtils.WKT_WRITER.write(geometry);
        }
        return this._results;
    }
}

