/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.core.operator.docvalsets.ProjectionBlockValSet;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.evaluator.TransformEvaluator;

public class ProjectionBlock
implements Block {
    private final Map<String, DataSource> _dataSourceMap;
    private final DataBlockCache _dataBlockCache;

    public ProjectionBlock(Map<String, DataSource> dataSourceMap, DataBlockCache dataBlockCache) {
        this._dataSourceMap = dataSourceMap;
        this._dataBlockCache = dataBlockCache;
    }

    public int getNumDocs() {
        return this._dataBlockCache.getNumDocs();
    }

    public int[] getDocIds() {
        return this._dataBlockCache.getDocIds();
    }

    public BlockValSet getBlockValueSet(String column) {
        return new ProjectionBlockValSet(this._dataBlockCache, column, this._dataSourceMap.get(column));
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }

    public void fillValues(String column, TransformEvaluator evaluator, int[] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, long[] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, float[] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, double[] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, BigDecimal[] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, String[] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, int[][] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, long[][] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, float[][] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, double[][] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }

    public void fillValues(String column, TransformEvaluator evaluator, String[][] buffer) {
        this._dataBlockCache.fillValues(column, evaluator, buffer);
    }
}

